(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["Kore"] = factory();
	else
		root["Kore"] = factory();
})(this, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	// The require scope
/******/ 	var __webpack_require__ = {};
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  ErrorCodes: () => (/* reexport */ ErrorCodes),
  Kore: () => (/* binding */ Kore),
  KoreAuthenticationError: () => (/* reexport */ KoreAuthenticationError),
  KoreError: () => (/* reexport */ KoreError),
  KoreNetworkError: () => (/* reexport */ KoreNetworkError),
  KoreNotFoundError: () => (/* reexport */ KoreNotFoundError),
  KorePaymentError: () => (/* reexport */ KorePaymentError),
  KoreRateLimitError: () => (/* reexport */ KoreRateLimitError),
  KoreServerError: () => (/* reexport */ KoreServerError),
  KoreValidationError: () => (/* reexport */ KoreValidationError),
  createErrorFromResponse: () => (/* reexport */ createErrorFromResponse),
  "default": () => (/* binding */ src),
  formatAmount: () => (/* reexport */ utils_formatAmount),
  generateIdempotencyKey: () => (/* reexport */ utils_generateIdempotencyKey),
  validateCurrency: () => (/* reexport */ utils_validateCurrency),
  validateEmail: () => (/* reexport */ utils_validateEmail)
});

;// ./src/errors.js
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _wrapNativeSuper(t) { var r = "function" == typeof Map ? new Map() : void 0; return _wrapNativeSuper = function _wrapNativeSuper(t) { if (null === t || !_isNativeFunction(t)) return t; if ("function" != typeof t) throw new TypeError("Super expression must either be null or a function"); if (void 0 !== r) { if (r.has(t)) return r.get(t); r.set(t, Wrapper); } function Wrapper() { return _construct(t, arguments, _getPrototypeOf(this).constructor); } return Wrapper.prototype = Object.create(t.prototype, { constructor: { value: Wrapper, enumerable: !1, writable: !0, configurable: !0 } }), _setPrototypeOf(Wrapper, t); }, _wrapNativeSuper(t); }
function _construct(t, e, r) { if (_isNativeReflectConstruct()) return Reflect.construct.apply(null, arguments); var o = [null]; o.push.apply(o, e); var p = new (t.bind.apply(t, o))(); return r && _setPrototypeOf(p, r.prototype), p; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _isNativeFunction(t) { try { return -1 !== Function.toString.call(t).indexOf("[native code]"); } catch (n) { return "function" == typeof t; } }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
/**
 * Base error class for all Kore SDK errors
 */
var KoreError = /*#__PURE__*/function (_Error) {
  function KoreError(message, code) {
    var _this;
    var details = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
    _classCallCheck(this, KoreError);
    _this = _callSuper(this, KoreError, [message]);
    _this.name = 'KoreError';
    _this.code = code;
    _this.details = details;

    // Maintains proper stack trace for where our error was thrown (only available on V8)
    if (Error.captureStackTrace) {
      Error.captureStackTrace(_this, _this.constructor);
    }
    return _this;
  }
  _inherits(KoreError, _Error);
  return _createClass(KoreError);
}(/*#__PURE__*/_wrapNativeSuper(Error));

/**
 * Authentication error - invalid or missing API key
 */
var KoreAuthenticationError = /*#__PURE__*/function (_KoreError) {
  function KoreAuthenticationError() {
    var _this2;
    var message = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'Authentication failed';
    var details = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    _classCallCheck(this, KoreAuthenticationError);
    _this2 = _callSuper(this, KoreAuthenticationError, [message, 'AUTHENTICATION_ERROR', details]);
    _this2.name = 'KoreAuthenticationError';
    return _this2;
  }
  _inherits(KoreAuthenticationError, _KoreError);
  return _createClass(KoreAuthenticationError);
}(KoreError);

/**
 * Validation error - invalid request parameters
 */
var KoreValidationError = /*#__PURE__*/function (_KoreError2) {
  function KoreValidationError() {
    var _this3;
    var message = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'Validation failed';
    var details = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    _classCallCheck(this, KoreValidationError);
    _this3 = _callSuper(this, KoreValidationError, [message, 'VALIDATION_ERROR', details]);
    _this3.name = 'KoreValidationError';
    return _this3;
  }
  _inherits(KoreValidationError, _KoreError2);
  return _createClass(KoreValidationError);
}(KoreError);

/**
 * Payment processing error
 */
var KorePaymentError = /*#__PURE__*/function (_KoreError3) {
  function KorePaymentError() {
    var _this4;
    var message = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'Payment processing failed';
    var details = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    _classCallCheck(this, KorePaymentError);
    _this4 = _callSuper(this, KorePaymentError, [message, 'PAYMENT_ERROR', details]);
    _this4.name = 'KorePaymentError';
    return _this4;
  }
  _inherits(KorePaymentError, _KoreError3);
  return _createClass(KorePaymentError);
}(KoreError);

/**
 * Network/connection error
 */
var KoreNetworkError = /*#__PURE__*/function (_KoreError4) {
  function KoreNetworkError() {
    var _this5;
    var message = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'Network error occurred';
    var details = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    _classCallCheck(this, KoreNetworkError);
    _this5 = _callSuper(this, KoreNetworkError, [message, 'NETWORK_ERROR', details]);
    _this5.name = 'KoreNetworkError';
    return _this5;
  }
  _inherits(KoreNetworkError, _KoreError4);
  return _createClass(KoreNetworkError);
}(KoreError);

/**
 * Rate limit error
 */
var KoreRateLimitError = /*#__PURE__*/function (_KoreError5) {
  function KoreRateLimitError() {
    var _this6;
    var message = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'Rate limit exceeded';
    var details = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    _classCallCheck(this, KoreRateLimitError);
    _this6 = _callSuper(this, KoreRateLimitError, [message, 'RATE_LIMIT_ERROR', details]);
    _this6.name = 'KoreRateLimitError';
    return _this6;
  }
  _inherits(KoreRateLimitError, _KoreError5);
  return _createClass(KoreRateLimitError);
}(KoreError);

/**
 * Not found error
 */
var KoreNotFoundError = /*#__PURE__*/function (_KoreError6) {
  function KoreNotFoundError() {
    var _this7;
    var message = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'Resource not found';
    var details = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    _classCallCheck(this, KoreNotFoundError);
    _this7 = _callSuper(this, KoreNotFoundError, [message, 'NOT_FOUND_ERROR', details]);
    _this7.name = 'KoreNotFoundError';
    return _this7;
  }
  _inherits(KoreNotFoundError, _KoreError6);
  return _createClass(KoreNotFoundError);
}(KoreError);

/**
 * Server error
 */
var KoreServerError = /*#__PURE__*/function (_KoreError7) {
  function KoreServerError() {
    var _this8;
    var message = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'Server error occurred';
    var details = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    _classCallCheck(this, KoreServerError);
    _this8 = _callSuper(this, KoreServerError, [message, 'SERVER_ERROR', details]);
    _this8.name = 'KoreServerError';
    return _this8;
  }
  _inherits(KoreServerError, _KoreError7);
  return _createClass(KoreServerError);
}(KoreError);

/**
 * Error code constants for SDK and redirect errors
 */
var ErrorCodes = {
  // SDK Errors
  AUTHENTICATION_ERROR: 'AUTHENTICATION_ERROR',
  VALIDATION_ERROR: 'VALIDATION_ERROR',
  PAYMENT_ERROR: 'PAYMENT_ERROR',
  NETWORK_ERROR: 'NETWORK_ERROR',
  RATE_LIMIT_ERROR: 'RATE_LIMIT_ERROR',
  NOT_FOUND_ERROR: 'NOT_FOUND_ERROR',
  SERVER_ERROR: 'SERVER_ERROR',
  // Redirect Errors
  SESSION_NOT_FOUND: 'SESSION_NOT_FOUND',
  PAYMENT_NOT_FOUND: 'PAYMENT_NOT_FOUND',
  GATEWAY_NOT_AVAILABLE: 'GATEWAY_NOT_AVAILABLE',
  GATEWAY_CREDENTIALS_ERROR: 'GATEWAY_CREDENTIALS_ERROR',
  GATEWAY_ADAPTER_ERROR: 'GATEWAY_ADAPTER_ERROR',
  GATEWAY_SESSION_CREATION_FAILED: 'GATEWAY_SESSION_CREATION_FAILED',
  GATEWAY_VERIFICATION_FAILED: 'GATEWAY_VERIFICATION_FAILED',
  GATEWAY_TIMEOUT: 'GATEWAY_TIMEOUT',
  NO_ACTIVE_API_KEY: 'NO_ACTIVE_API_KEY',
  RESOURCE_NOT_FOUND: 'RESOURCE_NOT_FOUND',
  BAD_REQUEST: 'BAD_REQUEST',
  FORBIDDEN: 'FORBIDDEN',
  INTERNAL_ERROR: 'INTERNAL_ERROR',
  UNKNOWN_ERROR: 'UNKNOWN_ERROR'
};

/**
 * Maps HTTP status codes to error classes
 */
function createErrorFromResponse(status, message, details) {
  switch (status) {
    case 401:
      return new KoreAuthenticationError(message, details);
    case 400:
      return new KoreValidationError(message, details);
    case 404:
      return new KoreNotFoundError(message, details);
    case 429:
      return new KoreRateLimitError(message, details);
    case 500:
    case 502:
    case 503:
    case 504:
      return new KoreServerError(message, details);
    default:
      if (status >= 400 && status < 500) {
        return new KorePaymentError(message, details);
      }
      return new KoreServerError(message, details);
  }
}
;// ./src/client.js
function _regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return _regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (u = i[(c = i[4]) ? 5 : (c = 3, 3)], i[4] = i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i["return"]) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, _regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, _regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), _regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", _regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), _regeneratorDefine2(u), _regeneratorDefine2(u, o, "Generator"), _regeneratorDefine2(u, n, function () { return this; }), _regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function _regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } _regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { function o(r, n) { _regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); } r ? i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n : (o("next", 0), o("throw", 1), o("return", 2)); }, _regeneratorDefine2(e, r, n, t); }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = client_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function client_typeof(o) { "@babel/helpers - typeof"; return client_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, client_typeof(o); }
function client_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function client_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, client_toPropertyKey(o.key), o); } }
function client_createClass(e, r, t) { return r && client_defineProperties(e.prototype, r), t && client_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function client_toPropertyKey(t) { var i = client_toPrimitive(t, "string"); return "symbol" == client_typeof(i) ? i : i + ""; }
function client_toPrimitive(t, r) { if ("object" != client_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != client_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


/**
 * HTTP client for making API requests to Kore Payment Platform
 */
var HttpClient = /*#__PURE__*/function () {
  function HttpClient(config) {
    client_classCallCheck(this, HttpClient);
    this.apiKey = config.apiKey;
    this.baseUrl = this._getBaseUrl(config);
    this.timeout = config.timeout || 30000;
    this.retryAttempts = config.retryAttempts || 3;
    this.retryDelay = config.retryDelay || 1000;
    this.onError = config.onError;
    this.onRequest = config.onRequest;
    this.onResponse = config.onResponse;
    this.debug = config.debug || false;
    this.logger = config.logger || console.log;

    // Validate HTTPS in production
    if (this.baseUrl && !this.baseUrl.startsWith('https://') && (config.environment === 'live' || !config.environment)) {
      throw new KoreError('HTTPS is required for API calls', 'VALIDATION_ERROR');
    }
  }

  /**
   * Gets the base URL based on environment
   */
  return client_createClass(HttpClient, [{
    key: "_getBaseUrl",
    value: function _getBaseUrl(config) {
      if (config.baseUrl) {
        return config.baseUrl;
      }
      if (config.environment === 'sandbox') {
        // return 'https://api-sandbox.kora.com';
        // return `http://192.168.1.31:3000`;
        return 'https://kora-backend-node.onrender.com';
      }

      // return 'https://api.kora.com';
      return 'https://kora-backend-node.onrender.com';
    }

    /**
     * Logs a message if debug mode is enabled
     */
  }, {
    key: "_log",
    value: function _log(message) {
      if (this.debug) {
        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }
        this.logger.apply(this, ["[Kore SDK] ".concat(message)].concat(args));
      }
    }

    /**
     * Masks sensitive data in logs
     */
  }, {
    key: "_maskSensitiveData",
    value: function _maskSensitiveData(data) {
      if (client_typeof(data) !== 'object' || data === null) {
        return data;
      }
      var masked = _objectSpread({}, data);
      var sensitiveKeys = ['apiKey', 'apiSecret', 'secret', 'password', 'token', 'authorization'];
      for (var _i = 0, _sensitiveKeys = sensitiveKeys; _i < _sensitiveKeys.length; _i++) {
        var key = _sensitiveKeys[_i];
        if (masked[key]) {
          masked[key] = '***';
        }
      }
      return masked;
    }

    /**
     * Creates a timeout promise
     */
  }, {
    key: "_createTimeout",
    value: function _createTimeout(ms) {
      return new Promise(function (_, reject) {
        setTimeout(function () {
          return reject(new KoreNetworkError('Request timeout'));
        }, ms);
      });
    }

    /**
     * Sleeps for specified milliseconds
     */
  }, {
    key: "_sleep",
    value: function _sleep(ms) {
      return new Promise(function (resolve) {
        return setTimeout(resolve, ms);
      });
    }

    /**
     * Makes an HTTP request with retry logic
     */
  }, {
    key: "request",
    value: (function () {
      var _request = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(method, endpoint) {
        var data,
          options,
          url,
          headers,
          requestConfig,
          lastError,
          attempt,
          timeoutPromise,
          fetchPromise,
          response,
          responseData,
          delay,
          _args = arguments,
          _t;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.p = _context.n) {
            case 0:
              data = _args.length > 2 && _args[2] !== undefined ? _args[2] : null;
              options = _args.length > 3 && _args[3] !== undefined ? _args[3] : {};
              url = "".concat(this.baseUrl).concat(endpoint);
              headers = _objectSpread({
                'Authorization': "Bearer ".concat(this.apiKey),
                'Content-Type': 'application/json'
              }, options.headers); // Add idempotency key if provided
              if (options.idempotencyKey) {
                headers['Idempotency-Key'] = options.idempotencyKey;
              }
              requestConfig = _objectSpread({
                method: method,
                headers: headers
              }, options.fetchOptions);
              if (data && (method === 'POST' || method === 'PUT' || method === 'PATCH')) {
                requestConfig.body = JSON.stringify(data);
              }

              // Call request interceptor
              if (this.onRequest) {
                this.onRequest(requestConfig);
              }
              this._log('Request:', method, url, this._maskSensitiveData(requestConfig));
              attempt = 0;
            case 1:
              if (!(attempt <= this.retryAttempts)) {
                _context.n = 8;
                break;
              }
              _context.p = 2;
              // Create timeout promise
              timeoutPromise = this._createTimeout(this.timeout); // Make request
              fetchPromise = fetch(url, requestConfig); // Race between fetch and timeout
              _context.n = 3;
              return Promise.race([fetchPromise, timeoutPromise]);
            case 3:
              response = _context.v;
              // Call response interceptor
              if (this.onResponse) {
                this.onResponse(response);
              }
              _context.n = 4;
              return this._handleResponse(response);
            case 4:
              responseData = _context.v;
              this._log('Response:', method, url, this._maskSensitiveData(responseData));
              return _context.a(2, responseData);
            case 5:
              _context.p = 5;
              _t = _context.v;
              lastError = _t;

              // Don't retry on certain errors
              if (!(_t instanceof KoreError && (_t.code === 'AUTHENTICATION_ERROR' || _t.code === 'VALIDATION_ERROR' || _t.code === 'NOT_FOUND_ERROR'))) {
                _context.n = 6;
                break;
              }
              throw _t;
            case 6:
              if (!(attempt < this.retryAttempts)) {
                _context.n = 7;
                break;
              }
              delay = this.retryDelay * Math.pow(2, attempt);
              this._log("Request failed, retrying in ".concat(delay, "ms... (attempt ").concat(attempt + 1, "/").concat(this.retryAttempts, ")"));
              _context.n = 7;
              return this._sleep(delay);
            case 7:
              attempt++;
              _context.n = 1;
              break;
            case 8:
              // All retries failed
              if (this.onError) {
                this.onError(lastError);
              }
              throw lastError;
            case 9:
              return _context.a(2);
          }
        }, _callee, this, [[2, 5]]);
      }));
      function request(_x, _x2) {
        return _request.apply(this, arguments);
      }
      return request;
    }()
    /**
     * Handles HTTP response
     */
    )
  }, {
    key: "_handleResponse",
    value: (function () {
      var _handleResponse2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(response) {
        var contentType, isJson, data, _data, _data2, _data3, errorMessage, errorDetails, _t2, _t3;
        return _regenerator().w(function (_context2) {
          while (1) switch (_context2.p = _context2.n) {
            case 0:
              contentType = response.headers.get('content-type');
              isJson = contentType && contentType.includes('application/json');
              _context2.p = 1;
              if (!isJson) {
                _context2.n = 3;
                break;
              }
              _context2.n = 2;
              return response.json();
            case 2:
              _t2 = _context2.v;
              _context2.n = 5;
              break;
            case 3:
              _context2.n = 4;
              return response.text();
            case 4:
              _t2 = _context2.v;
            case 5:
              data = _t2;
              _context2.n = 7;
              break;
            case 6:
              _context2.p = 6;
              _t3 = _context2.v;
              data = null;
            case 7:
              if (response.ok) {
                _context2.n = 8;
                break;
              }
              errorMessage = ((_data = data) === null || _data === void 0 ? void 0 : _data.message) || ((_data2 = data) === null || _data2 === void 0 ? void 0 : _data2.error) || "HTTP ".concat(response.status, ": ").concat(response.statusText);
              errorDetails = ((_data3 = data) === null || _data3 === void 0 ? void 0 : _data3.details) || data;
              throw createErrorFromResponse(response.status, errorMessage, errorDetails);
            case 8:
              return _context2.a(2, data);
          }
        }, _callee2, null, [[1, 6]]);
      }));
      function _handleResponse(_x3) {
        return _handleResponse2.apply(this, arguments);
      }
      return _handleResponse;
    }()
    /**
     * GET request
     */
    )
  }, {
    key: "get",
    value: (function () {
      var _get = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3(endpoint) {
        var options,
          _args3 = arguments;
        return _regenerator().w(function (_context3) {
          while (1) switch (_context3.n) {
            case 0:
              options = _args3.length > 1 && _args3[1] !== undefined ? _args3[1] : {};
              return _context3.a(2, this.request('GET', endpoint, null, options));
          }
        }, _callee3, this);
      }));
      function get(_x4) {
        return _get.apply(this, arguments);
      }
      return get;
    }()
    /**
     * POST request
     */
    )
  }, {
    key: "post",
    value: (function () {
      var _post = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4(endpoint, data) {
        var options,
          _args4 = arguments;
        return _regenerator().w(function (_context4) {
          while (1) switch (_context4.n) {
            case 0:
              options = _args4.length > 2 && _args4[2] !== undefined ? _args4[2] : {};
              return _context4.a(2, this.request('POST', endpoint, data, options));
          }
        }, _callee4, this);
      }));
      function post(_x5, _x6) {
        return _post.apply(this, arguments);
      }
      return post;
    }()
    /**
     * PUT request
     */
    )
  }, {
    key: "put",
    value: (function () {
      var _put = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee5(endpoint, data) {
        var options,
          _args5 = arguments;
        return _regenerator().w(function (_context5) {
          while (1) switch (_context5.n) {
            case 0:
              options = _args5.length > 2 && _args5[2] !== undefined ? _args5[2] : {};
              return _context5.a(2, this.request('PUT', endpoint, data, options));
          }
        }, _callee5, this);
      }));
      function put(_x7, _x8) {
        return _put.apply(this, arguments);
      }
      return put;
    }()
    /**
     * PATCH request
     */
    )
  }, {
    key: "patch",
    value: (function () {
      var _patch = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee6(endpoint, data) {
        var options,
          _args6 = arguments;
        return _regenerator().w(function (_context6) {
          while (1) switch (_context6.n) {
            case 0:
              options = _args6.length > 2 && _args6[2] !== undefined ? _args6[2] : {};
              return _context6.a(2, this.request('PATCH', endpoint, data, options));
          }
        }, _callee6, this);
      }));
      function patch(_x9, _x0) {
        return _patch.apply(this, arguments);
      }
      return patch;
    }()
    /**
     * DELETE request
     */
    )
  }, {
    key: "delete",
    value: (function () {
      var _delete2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee7(endpoint) {
        var options,
          _args7 = arguments;
        return _regenerator().w(function (_context7) {
          while (1) switch (_context7.n) {
            case 0:
              options = _args7.length > 1 && _args7[1] !== undefined ? _args7[1] : {};
              return _context7.a(2, this.request('DELETE', endpoint, null, options));
          }
        }, _callee7, this);
      }));
      function _delete(_x1) {
        return _delete2.apply(this, arguments);
      }
      return _delete;
    }())
  }]);
}();
;// ./src/signature.js
function signature_typeof(o) { "@babel/helpers - typeof"; return signature_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, signature_typeof(o); }
var _excluded = ["signature"],
  _excluded2 = ["signature"];
function signature_regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return signature_regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (u = i[(c = i[4]) ? 5 : (c = 3, 3)], i[4] = i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i["return"]) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (signature_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, signature_regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, signature_regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), signature_regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", signature_regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), signature_regeneratorDefine2(u), signature_regeneratorDefine2(u, o, "Generator"), signature_regeneratorDefine2(u, n, function () { return this; }), signature_regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (signature_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function signature_regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } signature_regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { function o(r, n) { signature_regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); } r ? i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n : (o("next", 0), o("throw", 1), o("return", 2)); }, signature_regeneratorDefine2(e, r, n, t); }
function signature_ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function signature_objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? signature_ownKeys(Object(t), !0).forEach(function (r) { signature_defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : signature_ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function signature_defineProperty(e, r, t) { return (r = signature_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function signature_toPropertyKey(t) { var i = signature_toPrimitive(t, "string"); return "symbol" == signature_typeof(i) ? i : i + ""; }
function signature_toPrimitive(t, r) { if ("object" != signature_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != signature_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function signature_asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function signature_asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { signature_asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { signature_asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } return t; }
/**
 * Verifies HMAC-SHA256 signature from payment gateway redirect
 * Note: This should ideally be done server-side for security
 * 
 * @param {Object} params - Redirect parameters
 * @param {string} [params.payment_id] - Payment ID (optional, may be null for errors)
 * @param {string} params.order_id - Order ID
 * @param {string} params.status - Payment status ('captured' | 'authorized' | 'failed' | 'canceled' | 'pending')
 * @param {string} [params.gateway] - Gateway code (optional)
 * @param {string} [params.error_code] - Error code (present if status is 'failed')
 * @param {string} [params.error_message] - Error message (present if status is 'failed')
 * @param {string} params.signature - HMAC-SHA256 signature
 * @param {string} apiSecret - Merchant API secret
 * @returns {boolean} True if signature is valid
 */
function signature_verifyRedirectSignature(params, apiSecret) {
  if (!params || !apiSecret || !params.signature) {
    return false;
  }
  try {
    // Extract signature from params
    var signature = params.signature,
      dataToSign = _objectWithoutProperties(params, _excluded);

    // Filter out undefined, null, and empty string values
    // Only include non-empty parameters in signature payload
    var filteredParams = {};
    for (var key in dataToSign) {
      var value = dataToSign[key];
      if (value !== undefined && value !== null && value !== '') {
        filteredParams[key] = value;
      }
    }

    // Create signature payload (sorted keys, RAW values - NO URL encoding per spec)
    var payload = Object.keys(filteredParams).sort().map(function (key) {
      return "".concat(key, "=").concat(filteredParams[key]);
    }).join('&');

    // Generate HMAC-SHA256 signature
    var crypto = window.crypto || window.msCrypto;
    if (!crypto || !crypto.subtle) {
      // Fallback: Use Web Crypto API polyfill or return false
      console.warn('Web Crypto API not available. Signature verification requires server-side implementation.');
      return false;
    }

    // Note: Web Crypto API is asynchronous, so for a synchronous function,
    // we'd need to use a different approach or make this async
    // For now, this is a placeholder that should be implemented server-side
    return false;
  } catch (error) {
    return false;
  }
}

/**
 * Asynchronously verifies HMAC-SHA256 signature according to the official specification
 * 
 * Algorithm:
 * 1. Extract signature from params
 * 2. Filter out empty/null/undefined values
 * 3. Canonicalize: Sort keys alphabetically, format as key=value&key2=value2 (NO URL encoding)
 * 4. Compute HMAC-SHA256, output as hexadecimal string (lowercase)
 * 5. Compare signatures (case-sensitive, constant-time)
 * 
 * @param {Object|URLSearchParams} params - Redirect parameters
 * @param {string} [params.payment_id] - Payment ID (optional, may be null for errors)
 * @param {string} params.order_id - Order ID
 * @param {string} params.status - Payment status ('captured' | 'authorized' | 'failed' | 'canceled' | 'pending')
 * @param {string} [params.gateway] - Gateway code (optional)
 * @param {string} [params.error_code] - Error code (present if status is 'failed')
 * @param {string} [params.error_message] - Error message (present if status is 'failed')
 * @param {string} params.signature - HMAC-SHA256 signature (hex string, lowercase)
 * @param {string} apiSecret - Merchant API secret
 * @param {boolean} [debug=false] - Enable debug logging
 * @returns {Promise<boolean>} True if signature is valid
 */
function signature_verifyRedirectSignatureAsync(_x, _x2) {
  return _verifyRedirectSignatureAsync.apply(this, arguments);
}
function _verifyRedirectSignatureAsync() {
  _verifyRedirectSignatureAsync = signature_asyncToGenerator(/*#__PURE__*/signature_regenerator().m(function _callee(params, apiSecret) {
    var debug,
      crypto,
      paramObj,
      receivedSignature,
      signature,
      paramsToSign,
      filteredParams,
      key,
      value,
      keys,
      canonical,
      encoder,
      keyData,
      messageData,
      cryptoKey,
      signatureBuffer,
      signatureArray,
      computedSignature,
      result,
      i,
      isValid,
      _args = arguments,
      _t;
    return signature_regenerator().w(function (_context) {
      while (1) switch (_context.p = _context.n) {
        case 0:
          debug = _args.length > 2 && _args[2] !== undefined ? _args[2] : false;
          if (!(!params || !apiSecret || !params.signature)) {
            _context.n = 1;
            break;
          }
          if (debug) console.log('[Signature] Missing params or apiSecret');
          return _context.a(2, false);
        case 1:
          _context.p = 1;
          crypto = window.crypto || window.msCrypto;
          if (!(!crypto || !crypto.subtle)) {
            _context.n = 2;
            break;
          }
          console.warn('Web Crypto API not available. Signature verification requires server-side implementation.');
          return _context.a(2, false);
        case 2:
          // Step 1: Convert to object if URLSearchParams
          paramObj = params instanceof URLSearchParams ? Object.fromEntries(params.entries()) : signature_objectSpread({}, params); // Step 2: Extract signature
          receivedSignature = paramObj.signature;
          if (receivedSignature) {
            _context.n = 3;
            break;
          }
          if (debug) console.log('[Signature] No signature in params');
          return _context.a(2, false);
        case 3:
          // Step 3: Remove signature from params for canonicalization
          signature = paramObj.signature, paramsToSign = _objectWithoutProperties(paramObj, _excluded2); // Step 4: Filter out undefined, null, and empty string values
          // Only include non-empty parameters in signature payload
          filteredParams = {};
          for (key in paramsToSign) {
            value = paramsToSign[key];
            if (value !== undefined && value !== null && value !== '') {
              filteredParams[key] = value;
            }
          }
          if (debug) {
            console.log('[Signature] Filtered params:', filteredParams);
            console.log('[Signature] Provided signature:', receivedSignature);
          }

          // Step 5: Canonicalize - Sort keys alphabetically, use RAW values (NO URL encoding)
          // Format: key1=value1&key2=value2&key3=value3
          keys = Object.keys(filteredParams).sort();
          canonical = keys.map(function (k) {
            return "".concat(k, "=").concat(filteredParams[k]);
          }).join('&');
          if (debug) {
            console.log('[Signature] Canonical string:', canonical);
          }

          // Step 6: Compute HMAC-SHA256
          encoder = new TextEncoder();
          keyData = encoder.encode(apiSecret);
          messageData = encoder.encode(canonical); // Import key for HMAC
          _context.n = 4;
          return crypto.subtle.importKey('raw', keyData, {
            name: 'HMAC',
            hash: 'SHA-256'
          }, false, ['sign']);
        case 4:
          cryptoKey = _context.v;
          _context.n = 5;
          return crypto.subtle.sign('HMAC', cryptoKey, messageData);
        case 5:
          signatureBuffer = _context.v;
          // Convert signature to hex string (lowercase as per spec)
          signatureArray = Array.from(new Uint8Array(signatureBuffer));
          computedSignature = signatureArray.map(function (b) {
            return b.toString(16).padStart(2, '0');
          }).join('').toLowerCase();
          if (debug) {
            console.log('[Signature] Computed signature (hex lowercase):', computedSignature);
            console.log('[Signature] Received signature:', receivedSignature);
            console.log('[Signature] Signatures match:', computedSignature === receivedSignature);
          }

          // Step 7: Compare signatures (case-sensitive as per spec)
          // Use constant-time comparison to prevent timing attacks
          if (!(computedSignature.length !== receivedSignature.length)) {
            _context.n = 6;
            break;
          }
          if (debug) console.log('[Signature] Length mismatch');
          return _context.a(2, false);
        case 6:
          result = 0;
          for (i = 0; i < computedSignature.length; i++) {
            result |= computedSignature.charCodeAt(i) ^ receivedSignature.charCodeAt(i);
          }
          isValid = result === 0;
          if (debug) {
            console.log('[Signature] Verification result:', isValid);
          }
          return _context.a(2, isValid);
        case 7:
          _context.p = 7;
          _t = _context.v;
          console.error('Signature verification error:', _t);
          if (debug) console.error('[Signature] Error details:', _t);
          return _context.a(2, false);
      }
    }, _callee, null, [[1, 7]]);
  }));
  return _verifyRedirectSignatureAsync.apply(this, arguments);
}
;// ./src/payment.js
function payment_typeof(o) { "@babel/helpers - typeof"; return payment_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, payment_typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function payment_regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return payment_regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (u = i[(c = i[4]) ? 5 : (c = 3, 3)], i[4] = i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i["return"]) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (payment_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, payment_regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, payment_regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), payment_regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", payment_regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), payment_regeneratorDefine2(u), payment_regeneratorDefine2(u, o, "Generator"), payment_regeneratorDefine2(u, n, function () { return this; }), payment_regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (payment_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function payment_regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } payment_regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { function o(r, n) { payment_regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); } r ? i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n : (o("next", 0), o("throw", 1), o("return", 2)); }, payment_regeneratorDefine2(e, r, n, t); }
function payment_ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function payment_objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? payment_ownKeys(Object(t), !0).forEach(function (r) { payment_defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : payment_ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function payment_defineProperty(e, r, t) { return (r = payment_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function payment_asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function payment_asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { payment_asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { payment_asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function payment_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function payment_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, payment_toPropertyKey(o.key), o); } }
function payment_createClass(e, r, t) { return r && payment_defineProperties(e.prototype, r), t && payment_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function payment_toPropertyKey(t) { var i = payment_toPrimitive(t, "string"); return "symbol" == payment_typeof(i) ? i : i + ""; }
function payment_toPrimitive(t, r) { if ("object" != payment_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != payment_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }



/**
 * Payment session and transaction management
 */
var PaymentService = /*#__PURE__*/function () {
  function PaymentService(client) {
    payment_classCallCheck(this, PaymentService);
    this.client = client;
  }

  /**
   * Creates a payment session (V1 - Redirect flow)
   * @param {Object} sessionData - Payment session data
   * @param {Object} options - Additional options
   * @returns {Promise<Object>} Session response
   */
  return payment_createClass(PaymentService, [{
    key: "createSession",
    value: (function () {
      var _createSession = payment_asyncToGenerator(/*#__PURE__*/payment_regenerator().m(function _callee(sessionData) {
        var options,
          idempotencyKey,
          requestOptions,
          _args = arguments;
        return payment_regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              options = _args.length > 1 && _args[1] !== undefined ? _args[1] : {};
              // Validate required fields
              this._validateSessionData(sessionData);

              // Generate idempotency key if not provided
              idempotencyKey = options.idempotencyKey || this._generateIdempotencyKey('createSession', sessionData.order_id);
              requestOptions = payment_objectSpread({
                idempotencyKey: idempotencyKey,
                timeout: options.timeout
              }, options);
              return _context.a(2, this.client.post('/v1/payments/sessions', sessionData, requestOptions));
          }
        }, _callee, this);
      }));
      function createSession(_x) {
        return _createSession.apply(this, arguments);
      }
      return createSession;
    }()
    /**
     * Creates an embedded payment session (V2 - Embedded flow)
     * Gateway is selected at session creation
     * @param {Object} sessionData - Payment session data (same format as V1)
     * @param {Object} options - Additional options
     * @returns {Promise<Object>} Session response with gateway-specific config
     */
    )
  }, {
    key: "createEmbeddedSession",
    value: (function () {
      var _createEmbeddedSession = payment_asyncToGenerator(/*#__PURE__*/payment_regenerator().m(function _callee2(sessionData) {
        var options,
          idempotencyKey,
          requestOptions,
          _args2 = arguments;
        return payment_regenerator().w(function (_context2) {
          while (1) switch (_context2.n) {
            case 0:
              options = _args2.length > 1 && _args2[1] !== undefined ? _args2[1] : {};
              // Validate required fields (same as V1)
              this._validateSessionData(sessionData);

              // Generate idempotency key if not provided
              idempotencyKey = options.idempotencyKey || this._generateIdempotencyKey('createEmbeddedSession', sessionData.order_id);
              requestOptions = payment_objectSpread({
                idempotencyKey: idempotencyKey,
                timeout: options.timeout
              }, options);
              return _context2.a(2, this.client.post('/v2/payments/sessions', sessionData, requestOptions));
          }
        }, _callee2, this);
      }));
      function createEmbeddedSession(_x2) {
        return _createEmbeddedSession.apply(this, arguments);
      }
      return createEmbeddedSession;
    }()
    /**
     * Gets payment session status
     * Works for both V1 and V2 sessions
     * @param {string} sessionId - Session ID
     * @param {Object} options - Options (version: 'v1' | 'v2')
     * @returns {Promise<Object>} Session status
     */
    )
  }, {
    key: "getSessionStatus",
    value: (function () {
      var _getSessionStatus = payment_asyncToGenerator(/*#__PURE__*/payment_regenerator().m(function _callee3(sessionId) {
        var options,
          version,
          _args3 = arguments;
        return payment_regenerator().w(function (_context3) {
          while (1) switch (_context3.n) {
            case 0:
              options = _args3.length > 1 && _args3[1] !== undefined ? _args3[1] : {};
              if (!(!sessionId || typeof sessionId !== 'string')) {
                _context3.n = 1;
                break;
              }
              throw new KoreValidationError('Session ID is required');
            case 1:
              version = options.version || 'v1';
              return _context3.a(2, this.client.get("/".concat(version, "/payments/sessions/").concat(sessionId)));
          }
        }, _callee3, this);
      }));
      function getSessionStatus(_x3) {
        return _getSessionStatus.apply(this, arguments);
      }
      return getSessionStatus;
    }()
    /**
     * Gets transaction details
     * @param {string|number} paymentId - Payment ID
     * @returns {Promise<Object>} Transaction details
     */
    )
  }, {
    key: "getTransaction",
    value: (function () {
      var _getTransaction = payment_asyncToGenerator(/*#__PURE__*/payment_regenerator().m(function _callee4(paymentId) {
        return payment_regenerator().w(function (_context4) {
          while (1) switch (_context4.n) {
            case 0:
              if (paymentId) {
                _context4.n = 1;
                break;
              }
              throw new KoreValidationError('Payment ID is required');
            case 1:
              return _context4.a(2, this.client.get("/v1/payments/".concat(paymentId)));
          }
        }, _callee4, this);
      }));
      function getTransaction(_x4) {
        return _getTransaction.apply(this, arguments);
      }
      return getTransaction;
    }()
    /**
     * Redirects browser to payment gateway
     * @param {string} redirectUrl - Redirect URL from createSession
     * @param {Object} options - Redirect options
     */
    )
  }, {
    key: "redirectToPayment",
    value: function redirectToPayment(redirectUrl) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      if (!redirectUrl || typeof redirectUrl !== 'string') {
        throw new KoreValidationError('Redirect URL is required');
      }
      var target = options.target || '_self';
      if (target === '_blank') {
        window.open(redirectUrl, '_blank');
      } else {
        window.location.href = redirectUrl;
      }
    }

    /**
     * Polls payment status until completion or failure
     * Works for both V1 and V2 sessions
     * @param {string} sessionId - Session ID
     * @param {Object} options - Polling options
     * @returns {Promise<Object>} Final session status
     */
  }, {
    key: "pollPaymentStatus",
    value: (function () {
      var _pollPaymentStatus = payment_asyncToGenerator(/*#__PURE__*/payment_regenerator().m(function _callee6(sessionId) {
        var _this = this;
        var options,
          interval,
          maxAttempts,
          onStatusChange,
          version,
          lastStatus,
          attempts,
          _args6 = arguments;
        return payment_regenerator().w(function (_context6) {
          while (1) switch (_context6.n) {
            case 0:
              options = _args6.length > 1 && _args6[1] !== undefined ? _args6[1] : {};
              if (!(!sessionId || typeof sessionId !== 'string')) {
                _context6.n = 1;
                break;
              }
              throw new KoreValidationError('Session ID is required');
            case 1:
              interval = options.interval || 2000;
              maxAttempts = options.maxAttempts || 150; // Increased for embedded flows (5 minutes at 2s interval)
              onStatusChange = options.onStatusChange;
              version = options.version || 'v1'; // Support V2 sessions
              lastStatus = null;
              attempts = 0;
              return _context6.a(2, new Promise(function (resolve, reject) {
                var _poll = /*#__PURE__*/function () {
                  var _ref = payment_asyncToGenerator(/*#__PURE__*/payment_regenerator().m(function _callee5() {
                    var status, _t;
                    return payment_regenerator().w(function (_context5) {
                      while (1) switch (_context5.p = _context5.n) {
                        case 0:
                          _context5.p = 0;
                          attempts++;
                          _context5.n = 1;
                          return _this.getSessionStatus(sessionId, {
                            version: version
                          });
                        case 1:
                          status = _context5.v;
                          // Check if status changed
                          if (lastStatus && lastStatus.status !== status.status && onStatusChange) {
                            onStatusChange(status);
                          }
                          lastStatus = status;

                          // Check if completed or failed
                          if (!(status.status === 'completed' || status.status === 'failed' || status.status === 'canceled')) {
                            _context5.n = 2;
                            break;
                          }
                          resolve(status);
                          return _context5.a(2);
                        case 2:
                          if (!(attempts >= maxAttempts)) {
                            _context5.n = 3;
                            break;
                          }
                          resolve(status);
                          return _context5.a(2);
                        case 3:
                          // Continue polling
                          setTimeout(_poll, interval);
                          _context5.n = 5;
                          break;
                        case 4:
                          _context5.p = 4;
                          _t = _context5.v;
                          reject(_t);
                        case 5:
                          return _context5.a(2);
                      }
                    }, _callee5, null, [[0, 4]]);
                  }));
                  return function poll() {
                    return _ref.apply(this, arguments);
                  };
                }();
                _poll();
              }));
          }
        }, _callee6);
      }));
      function pollPaymentStatus(_x5) {
        return _pollPaymentStatus.apply(this, arguments);
      }
      return pollPaymentStatus;
    }()
    /**
     * Gets Adyen payment methods for Drop-in SDK
     * @param {string} sessionId - Session ID (optional)
     * @param {Object} options - Options (countryCode, currency)
     * @returns {Promise<Object>} Payment methods response
     */
    )
  }, {
    key: "getAdyenPaymentMethods",
    value: (function () {
      var _getAdyenPaymentMethods = payment_asyncToGenerator(/*#__PURE__*/payment_regenerator().m(function _callee7() {
        var sessionId,
          options,
          params,
          queryString,
          endpoint,
          _args7 = arguments;
        return payment_regenerator().w(function (_context7) {
          while (1) switch (_context7.n) {
            case 0:
              sessionId = _args7.length > 0 && _args7[0] !== undefined ? _args7[0] : null;
              options = _args7.length > 1 && _args7[1] !== undefined ? _args7[1] : {};
              params = new URLSearchParams();
              if (sessionId) {
                params.append('session_id', sessionId);
              }
              if (options.countryCode) {
                params.append('country_code', options.countryCode);
              }
              if (options.currency) {
                params.append('currency', options.currency);
              }
              queryString = params.toString();
              endpoint = "/v2/payments/methods".concat(queryString ? "?".concat(queryString) : '');
              return _context7.a(2, this.client.get(endpoint));
          }
        }, _callee7, this);
      }));
      function getAdyenPaymentMethods() {
        return _getAdyenPaymentMethods.apply(this, arguments);
      }
      return getAdyenPaymentMethods;
    }()
    /**
     * Processes Adyen payment after user submits form
     * @param {Object} data - Payment data
     * @param {string} data.session_id - Session ID
     * @param {Object} data.paymentData - Payment data from Adyen Drop-in component
     * @returns {Promise<Object>} Payment result (may contain action for 3DS)
     */
    )
  }, {
    key: "processAdyenPayment",
    value: (function () {
      var _processAdyenPayment = payment_asyncToGenerator(/*#__PURE__*/payment_regenerator().m(function _callee8(data) {
        return payment_regenerator().w(function (_context8) {
          while (1) switch (_context8.n) {
            case 0:
              if (!(!data || !data.session_id)) {
                _context8.n = 1;
                break;
              }
              throw new KoreValidationError('Session ID is required');
            case 1:
              if (data.paymentData) {
                _context8.n = 2;
                break;
              }
              throw new KoreValidationError('Payment data is required');
            case 2:
              return _context8.a(2, this.client.post('/v2/payments/process', data));
          }
        }, _callee8, this);
      }));
      function processAdyenPayment(_x6) {
        return _processAdyenPayment.apply(this, arguments);
      }
      return processAdyenPayment;
    }()
    /**
     * Updates payment with gateway payment ID and optional session result
     * Used when payment SDK completes and provides payment ID
     * For Adyen Sessions flow, pspReference might not be available, so sessionResult can be sent alone
     * @param {string} sessionId - Session ID
     * @param {string|null} gatewayPaymentId - Gateway payment ID (e.g., Checkout.com payment ID, Adyen pspReference) - optional for Adyen Sessions flow
     * @param {string|null} gatewaySessionResult - Optional gateway session result (e.g., Adyen sessionResult from onPaymentCompleted) - required if gatewayPaymentId not provided
     * @returns {Promise<Object>} Updated payment
     */
    )
  }, {
    key: "updatePaymentGatewayId",
    value: (function () {
      var _updatePaymentGatewayId = payment_asyncToGenerator(/*#__PURE__*/payment_regenerator().m(function _callee9(sessionId) {
        var gatewayPaymentId,
          gatewaySessionResult,
          payload,
          _args9 = arguments;
        return payment_regenerator().w(function (_context9) {
          while (1) switch (_context9.n) {
            case 0:
              gatewayPaymentId = _args9.length > 1 && _args9[1] !== undefined ? _args9[1] : null;
              gatewaySessionResult = _args9.length > 2 && _args9[2] !== undefined ? _args9[2] : null;
              if (!(!sessionId || typeof sessionId !== 'string')) {
                _context9.n = 1;
                break;
              }
              throw new KoreValidationError('Session ID is required');
            case 1:
              if (!(!gatewayPaymentId && !gatewaySessionResult)) {
                _context9.n = 2;
                break;
              }
              throw new KoreValidationError('Either gatewayPaymentId or gatewaySessionResult must be provided');
            case 2:
              payload = {
                session_id: sessionId
              }; // Include gatewayPaymentId if provided
              if (gatewayPaymentId) {
                payload.gateway_payment_id = gatewayPaymentId;
              }

              // Include sessionResult if provided (for Adyen Sessions flow)
              if (gatewaySessionResult) {
                payload.gateway_session_result = gatewaySessionResult;
              }
              return _context9.a(2, this.client.post('/v2/payments/update-gateway-id', payload));
          }
        }, _callee9, this);
      }));
      function updatePaymentGatewayId(_x7) {
        return _updatePaymentGatewayId.apply(this, arguments);
      }
      return updatePaymentGatewayId;
    }()
    /**
     * Handles redirect return from payment gateway
     * Parses URL parameters, verifies signature, and returns structured result
     * Note: This method is async because signature verification requires async operations
     * 
     * @param {URLSearchParams|Object} urlParams - URL search parameters from returnUrl
     * @param {string} apiSecret - Merchant API secret (server-side recommended)
     * @returns {Promise<Object>} Structured result with success/error data
     * @returns {boolean} returns.success - True if payment succeeded
     * @returns {Object} [returns.data] - Success data (payment_id, order_id, status, gateway)
     * @returns {Object} [returns.error] - Error data (code, message, payment_id, order_id, gateway)
     */
    )
  }, {
    key: "handleRedirectReturn",
    value: (function () {
      var _handleRedirectReturn = payment_asyncToGenerator(/*#__PURE__*/payment_regenerator().m(function _callee0(urlParams, apiSecret) {
        var _this$client, params, _iterator, _step, _step$value, key, value, _params, payment_id, order_id, status, gateway, error_code, error_message, signature, signatureParams, debug, isValid, filtered, canonical, _t2;
        return payment_regenerator().w(function (_context0) {
          while (1) switch (_context0.p = _context0.n) {
            case 0:
              if (urlParams) {
                _context0.n = 1;
                break;
              }
              return _context0.a(2, {
                success: false,
                error: {
                  code: 'INVALID_PARAMS',
                  message: 'URL parameters are required'
                }
              });
            case 1:
              if (apiSecret) {
                _context0.n = 2;
                break;
              }
              return _context0.a(2, {
                success: false,
                error: {
                  code: 'MISSING_SECRET',
                  message: 'API secret is required for signature verification'
                }
              });
            case 2:
              _context0.p = 2;
              // Convert URLSearchParams to object if needed
              params = {};
              if (!(urlParams instanceof URLSearchParams)) {
                _context0.n = 3;
                break;
              }
              _iterator = _createForOfIteratorHelper(urlParams.entries());
              try {
                for (_iterator.s(); !(_step = _iterator.n()).done;) {
                  _step$value = _slicedToArray(_step.value, 2), key = _step$value[0], value = _step$value[1];
                  params[key] = value;
                }
              } catch (err) {
                _iterator.e(err);
              } finally {
                _iterator.f();
              }
              _context0.n = 5;
              break;
            case 3:
              if (!(payment_typeof(urlParams) === 'object')) {
                _context0.n = 4;
                break;
              }
              params = payment_objectSpread({}, urlParams);
              _context0.n = 5;
              break;
            case 4:
              return _context0.a(2, {
                success: false,
                error: {
                  code: 'INVALID_PARAMS',
                  message: 'URL parameters must be URLSearchParams or object'
                }
              });
            case 5:
              // Extract required parameters
              _params = params, payment_id = _params.payment_id, order_id = _params.order_id, status = _params.status, gateway = _params.gateway, error_code = _params.error_code, error_message = _params.error_message, signature = _params.signature; // Validate required fields
              if (order_id) {
                _context0.n = 6;
                break;
              }
              return _context0.a(2, {
                success: false,
                error: {
                  code: 'INVALID_PARAMS',
                  message: 'order_id is required'
                }
              });
            case 6:
              if (status) {
                _context0.n = 7;
                break;
              }
              return _context0.a(2, {
                success: false,
                error: {
                  code: 'INVALID_PARAMS',
                  message: 'status is required'
                }
              });
            case 7:
              if (signature) {
                _context0.n = 8;
                break;
              }
              return _context0.a(2, {
                success: false,
                error: {
                  code: 'INVALID_PARAMS',
                  message: 'signature is required'
                }
              });
            case 8:
              // Build params object for signature verification
              signatureParams = payment_objectSpread(payment_objectSpread(payment_objectSpread(payment_objectSpread(payment_objectSpread({}, payment_id && {
                payment_id: payment_id
              }), {}, {
                order_id: order_id,
                status: status
              }, gateway && {
                gateway: gateway
              }), error_code && {
                error_code: error_code
              }), error_message && {
                error_message: error_message
              }), {}, {
                signature: signature
              }); // Verify signature (enable debug if SDK debug mode is on)
              debug = ((_this$client = this.client) === null || _this$client === void 0 ? void 0 : _this$client.debug) || false;
              _context0.n = 9;
              return signature_verifyRedirectSignatureAsync(signatureParams, apiSecret, debug);
            case 9:
              isValid = _context0.v;
              if (isValid) {
                _context0.n = 10;
                break;
              }
              // Log debug information if enabled
              if (debug) {
                console.error('[Kore SDK] Signature verification failed');
                console.error('[Kore SDK] Signature params:', signatureParams);
                // Show canonical string (raw values, no URL encoding per spec)
                filtered = Object.keys(signatureParams).filter(function (k) {
                  return k !== 'signature' && signatureParams[k] !== undefined && signatureParams[k] !== null && signatureParams[k] !== '';
                });
                canonical = filtered.sort().map(function (k) {
                  return "".concat(k, "=").concat(signatureParams[k]);
                }).join('&');
                console.error('[Kore SDK] Canonical string used:', canonical);
              }
              return _context0.a(2, {
                success: false,
                error: payment_objectSpread(payment_objectSpread(payment_objectSpread({
                  code: 'SIGNATURE_VERIFICATION_FAILED',
                  message: 'Invalid redirect signature. Please verify your API secret and ensure signature format matches backend expectations.'
                }, payment_id && {
                  payment_id: payment_id
                }), order_id && {
                  order_id: order_id
                }), gateway && {
                  gateway: gateway
                })
              });
            case 10:
              if (!(status === 'failed')) {
                _context0.n = 11;
                break;
              }
              return _context0.a(2, {
                success: false,
                error: payment_objectSpread(payment_objectSpread(payment_objectSpread({
                  code: error_code || 'PAYMENT_FAILED',
                  message: error_message || 'Payment failed'
                }, payment_id && {
                  payment_id: payment_id
                }), order_id && {
                  order_id: order_id
                }), gateway && {
                  gateway: gateway
                })
              });
            case 11:
              if (!(status === 'captured' || status === 'authorized')) {
                _context0.n = 12;
                break;
              }
              return _context0.a(2, {
                success: true,
                data: payment_objectSpread({
                  payment_id: payment_id || '',
                  order_id: order_id,
                  status: status
                }, gateway && {
                  gateway: gateway
                })
              });
            case 12:
              return _context0.a(2, {
                success: status !== 'canceled',
                data: payment_objectSpread(payment_objectSpread({}, payment_id && {
                  payment_id: payment_id
                }), {}, {
                  order_id: order_id,
                  status: status
                }, gateway && {
                  gateway: gateway
                })
              });
            case 13:
              _context0.p = 13;
              _t2 = _context0.v;
              return _context0.a(2, {
                success: false,
                error: {
                  code: 'PARSE_ERROR',
                  message: _t2.message || 'Failed to parse redirect parameters'
                }
              });
          }
        }, _callee0, this, [[2, 13]]);
      }));
      function handleRedirectReturn(_x8, _x9) {
        return _handleRedirectReturn.apply(this, arguments);
      }
      return handleRedirectReturn;
    }()
    /**
     * Validates session data
     * @private
     */
    )
  }, {
    key: "_validateSessionData",
    value: function _validateSessionData(data) {
      if (!data) {
        throw new KoreValidationError('Session data is required');
      }
      var required = ['order_id', 'amount', 'currency', 'payer', 'billing', 'return_url', 'cancel_url'];
      var missing = required.filter(function (field) {
        return !data[field];
      });
      if (missing.length > 0) {
        throw new KoreValidationError("Missing required fields: ".concat(missing.join(', ')));
      }

      // Validate payer
      if (!data.payer.email || !data.payer.name) {
        throw new KoreValidationError('Payer email and name are required');
      }

      // Validate billing
      var billingRequired = ['address_line_1', 'city', 'postal_code', 'country'];
      var billingMissing = billingRequired.filter(function (field) {
        return !data.billing[field];
      });
      if (billingMissing.length > 0) {
        throw new KoreValidationError("Missing required billing fields: ".concat(billingMissing.join(', ')));
      }

      // Validate amount
      if (typeof data.amount !== 'number' || data.amount <= 0) {
        throw new KoreValidationError('Amount must be a positive number');
      }

      // Validate currency
      if (typeof data.currency !== 'string' || data.currency.length !== 3) {
        throw new KoreValidationError('Currency must be a valid ISO-4217 code (3 characters)');
      }
    }

    /**
     * Generates or retrieves stored idempotency key
     * @private
     */
  }, {
    key: "_generateIdempotencyKey",
    value: function _generateIdempotencyKey(operation, orderId) {
      // Try to get stored key for this order
      try {
        if (typeof Storage !== 'undefined' && window.sessionStorage) {
          var stored = JSON.parse(window.sessionStorage.getItem('kora_idempotency_keys') || '{}');
          var key = "".concat(operation, "_").concat(orderId);
          if (stored[key]) {
            return stored[key];
          }

          // Generate new key
          var newKey = this._uuidv4();
          stored[key] = newKey;
          window.sessionStorage.setItem('kora_idempotency_keys', JSON.stringify(stored));
          return newKey;
        }
      } catch (e) {
        // Fallback to generating new key
      }
      return this._uuidv4();
    }

    /**
     * Generates UUID v4
     * @private
     */
  }, {
    key: "_uuidv4",
    value: function _uuidv4() {
      return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        var r = Math.random() * 16 | 0;
        var v = c === 'x' ? r : r & 0x3 | 0x8;
        return v.toString(16);
      });
    }
  }]);
}();
;// ./src/embedded.js
function embedded_typeof(o) { "@babel/helpers - typeof"; return embedded_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, embedded_typeof(o); }
function embedded_ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function embedded_objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? embedded_ownKeys(Object(t), !0).forEach(function (r) { embedded_defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : embedded_ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function embedded_defineProperty(e, r, t) { return (r = embedded_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function embedded_regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return embedded_regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (u = i[(c = i[4]) ? 5 : (c = 3, 3)], i[4] = i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i["return"]) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (embedded_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, embedded_regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, embedded_regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), embedded_regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", embedded_regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), embedded_regeneratorDefine2(u), embedded_regeneratorDefine2(u, o, "Generator"), embedded_regeneratorDefine2(u, n, function () { return this; }), embedded_regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (embedded_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function embedded_regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } embedded_regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { function o(r, n) { embedded_regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); } r ? i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n : (o("next", 0), o("throw", 1), o("return", 2)); }, embedded_regeneratorDefine2(e, r, n, t); }
function embedded_asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function embedded_asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { embedded_asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { embedded_asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function embedded_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function embedded_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, embedded_toPropertyKey(o.key), o); } }
function embedded_createClass(e, r, t) { return r && embedded_defineProperties(e.prototype, r), t && embedded_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function embedded_toPropertyKey(t) { var i = embedded_toPrimitive(t, "string"); return "symbol" == embedded_typeof(i) ? i : i + ""; }
function embedded_toPrimitive(t, r) { if ("object" != embedded_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != embedded_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


/**
 * Embedded payment SDK integration
 * Handles Checkout.com Flow, Adyen Drop-in, and QiCard iframe
 */
var EmbeddedPaymentService = /*#__PURE__*/function () {
  function EmbeddedPaymentService(client, paymentService) {
    embedded_classCallCheck(this, EmbeddedPaymentService);
    this.client = client;
    this.payment = paymentService;
    this.loadedScripts = new Set();
    this.loadedStylesheets = new Set();
  }

  /**
   * Loads an external script dynamically
   * @param {string} src - Script source URL
   * @returns {Promise<void>}
   */
  return embedded_createClass(EmbeddedPaymentService, [{
    key: "loadScript",
    value: (function () {
      var _loadScript = embedded_asyncToGenerator(/*#__PURE__*/embedded_regenerator().m(function _callee(src) {
        var _this = this;
        var existingScript;
        return embedded_regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              if (!this.loadedScripts.has(src)) {
                _context.n = 1;
                break;
              }
              return _context.a(2, Promise.resolve());
            case 1:
              // Check if script already exists in DOM
              existingScript = document.querySelector("script[src=\"".concat(src, "\"]"));
              if (!existingScript) {
                _context.n = 2;
                break;
              }
              this.loadedScripts.add(src);
              return _context.a(2, Promise.resolve());
            case 2:
              return _context.a(2, new Promise(function (resolve, reject) {
                var script = document.createElement('script');
                script.src = src;
                script.async = true;
                script.onload = function () {
                  _this.loadedScripts.add(src);
                  resolve();
                };
                script.onerror = function () {
                  reject(new KoreError("Failed to load script: ".concat(src), 'SCRIPT_LOAD_ERROR'));
                };
                document.head.appendChild(script);
              }));
          }
        }, _callee, this);
      }));
      function loadScript(_x) {
        return _loadScript.apply(this, arguments);
      }
      return loadScript;
    }()
    /**
     * Loads an external stylesheet dynamically
     * @param {string} href - Stylesheet URL
     * @returns {Promise<void>}
     */
    )
  }, {
    key: "loadStylesheet",
    value: (function () {
      var _loadStylesheet = embedded_asyncToGenerator(/*#__PURE__*/embedded_regenerator().m(function _callee2(href) {
        var _this2 = this;
        var existingLink;
        return embedded_regenerator().w(function (_context2) {
          while (1) switch (_context2.n) {
            case 0:
              if (!this.loadedStylesheets.has(href)) {
                _context2.n = 1;
                break;
              }
              return _context2.a(2, Promise.resolve());
            case 1:
              // Check if stylesheet already exists in DOM
              existingLink = document.querySelector("link[href=\"".concat(href, "\"]"));
              if (!existingLink) {
                _context2.n = 2;
                break;
              }
              this.loadedStylesheets.add(href);
              return _context2.a(2, Promise.resolve());
            case 2:
              return _context2.a(2, new Promise(function (resolve, reject) {
                var link = document.createElement('link');
                link.rel = 'stylesheet';
                link.href = href;
                link.crossOrigin = 'anonymous'; // Required for CDN resources
                link.onload = function () {
                  console.log('Stylesheet loaded successfully:', href);
                  _this2.loadedStylesheets.add(href);
                  resolve();
                };
                link.onerror = function (e) {
                  console.error('Failed to load stylesheet:', href, e);
                  reject(new KoreError("Failed to load stylesheet: ".concat(href), 'STYLESHEET_LOAD_ERROR'));
                };
                document.head.appendChild(link);
              }));
          }
        }, _callee2, this);
      }));
      function loadStylesheet(_x2) {
        return _loadStylesheet.apply(this, arguments);
      }
      return loadStylesheet;
    }()
    /**
     * Initializes Checkout.com Flow SDK
     * @param {Object} config - Configuration
     * @param {Object} config.session - Session object from createEmbeddedSession
     * @param {string} config.container - CSS selector for container element
     * @param {Function} config.onSuccess - Success callback
     * @param {Function} config.onError - Error callback
     * @returns {Promise<Object>} Flow instance
     */
    )
  }, {
    key: "initializeCheckoutFlow",
    value: (function () {
      var _initializeCheckoutFlow = embedded_asyncToGenerator(/*#__PURE__*/embedded_regenerator().m(function _callee4(config) {
        var _this3 = this;
        var session, container, onSuccess, _onError, _session$gateway_conf, publicKey, paymentSession, environment, sdkUrl, attempts, maxAttempts, error, checkout, flowComponent, containerElement, flowInstance, _t3, _t4;
        return embedded_regenerator().w(function (_context4) {
          while (1) switch (_context4.p = _context4.n) {
            case 0:
              session = config.session, container = config.container, onSuccess = config.onSuccess, _onError = config.onError;
              if (!(!session || !session.gateway_config)) {
                _context4.n = 1;
                break;
              }
              throw new KoreValidationError('Invalid session: gateway_config not found');
            case 1:
              _session$gateway_conf = session.gateway_config, publicKey = _session$gateway_conf.publicKey, paymentSession = _session$gateway_conf.paymentSession, environment = _session$gateway_conf.environment;
              if (!(!publicKey || !paymentSession)) {
                _context4.n = 2;
                break;
              }
              throw new KoreValidationError('Checkout.com Flow requires publicKey and paymentSession');
            case 2:
              // Load Checkout.com Flow SDK
              sdkUrl = 'https://checkout-web-components.checkout.com/index.js';
              _context4.p = 3;
              _context4.n = 4;
              return this.loadScript(sdkUrl);
            case 4:
              _context4.n = 6;
              break;
            case 5:
              _context4.p = 5;
              _t3 = _context4.v;
              if (_onError) _onError(_t3);
              throw _t3;
            case 6:
              // Wait for CheckoutWebComponents to be available (race condition fix)
              // The script may load but CheckoutWebComponents might not be immediately available
              attempts = 0;
              maxAttempts = 50; // 5 seconds max wait (50 * 100ms)
            case 7:
              if (!(!window.CheckoutWebComponents && attempts < maxAttempts)) {
                _context4.n = 9;
                break;
              }
              _context4.n = 8;
              return new Promise(function (resolve) {
                return setTimeout(resolve, 100);
              });
            case 8:
              attempts++;
              _context4.n = 7;
              break;
            case 9:
              if (window.CheckoutWebComponents) {
                _context4.n = 10;
                break;
              }
              error = new KoreError('Checkout.com Flow SDK not loaded', 'SDK_LOAD_ERROR');
              if (_onError) _onError(error);
              throw error;
            case 10:
              _context4.p = 10;
              _context4.n = 11;
              return CheckoutWebComponents({
                publicKey: publicKey,
                environment: environment,
                paymentSession: paymentSession,
                // Event handlers are passed directly to CheckoutWebComponents constructor
                onReady: function onReady() {
                  // Flow is ready
                  console.log('Checkout.com Flow is ready');
                },
                onPaymentCompleted: function () {
                  var _onPaymentCompleted = embedded_asyncToGenerator(/*#__PURE__*/embedded_regenerator().m(function _callee3(component, paymentResponse) {
                    var finalStatus, _t, _t2;
                    return embedded_regenerator().w(function (_context3) {
                      while (1) switch (_context3.p = _context3.n) {
                        case 0:
                          _context3.p = 0;
                          if (!paymentResponse.id) {
                            _context3.n = 4;
                            break;
                          }
                          _context3.p = 1;
                          _context3.n = 2;
                          return _this3.payment.updatePaymentGatewayId(session.session_id, paymentResponse.id);
                        case 2:
                          _context3.n = 4;
                          break;
                        case 3:
                          _context3.p = 3;
                          _t = _context3.v;
                          // Log but don't fail - payment ID update is optional
                          console.warn('Failed to update payment gateway ID:', _t.message);
                        case 4:
                          _context3.n = 5;
                          return _this3.payment.pollPaymentStatus(session.session_id, {
                            version: 'v2',
                            interval: 1000,
                            maxAttempts: 30
                          });
                        case 5:
                          finalStatus = _context3.v;
                          if (onSuccess) {
                            onSuccess({
                              payment_id: paymentResponse.id,
                              payment_response: paymentResponse,
                              session: finalStatus
                            });
                          }
                          _context3.n = 7;
                          break;
                        case 6:
                          _context3.p = 6;
                          _t2 = _context3.v;
                          if (_onError) _onError(_t2);
                        case 7:
                          return _context3.a(2);
                      }
                    }, _callee3, null, [[1, 3], [0, 6]]);
                  }));
                  function onPaymentCompleted(_x4, _x5) {
                    return _onPaymentCompleted.apply(this, arguments);
                  }
                  return onPaymentCompleted;
                }(),
                onChange: function onChange(component) {
                  // Component state changed
                  // Optional: can be used for validation feedback
                  console.log("Checkout.com Flow onChange: isValid=".concat(component.isValid(), ", type=").concat(component.type));
                },
                onError: function onError(component, error) {
                  // Error occurred
                  if (_onError) {
                    _onError(error);
                  }
                }
              });
            case 11:
              checkout = _context4.v;
              // Step 2: Create flow component
              flowComponent = checkout.create('flow'); // Step 3: Mount Flow
              containerElement = document.querySelector(container);
              if (containerElement) {
                _context4.n = 12;
                break;
              }
              throw new KoreValidationError("Container not found: ".concat(container));
            case 12:
              flowInstance = flowComponent.mount(containerElement); // Note: Event handlers are already set up in CheckoutWebComponents() constructor above
              // No need to use .on() - that method doesn't exist on flowInstance
              // Events are handled via onPaymentCompleted, onError, etc. passed to CheckoutWebComponents()
              return _context4.a(2, flowInstance);
            case 13:
              _context4.p = 13;
              _t4 = _context4.v;
              if (_onError) _onError(_t4);
              throw _t4;
            case 14:
              return _context4.a(2);
          }
        }, _callee4, this, [[10, 13], [3, 5]]);
      }));
      function initializeCheckoutFlow(_x3) {
        return _initializeCheckoutFlow.apply(this, arguments);
      }
      return initializeCheckoutFlow;
    }()
    /**
     * Initializes Adyen Drop-in SDK using Sessions flow
     * @param {Object} config - Configuration
     * @param {Object} config.session - Session object from createEmbeddedSession (must include gateway_config.session)
     * @param {string} config.countryCode - Country code (e.g., 'US', 'GB') - required for Adyen v6+
     * @param {string} config.container - CSS selector for container element
     * @param {Function} config.onSuccess - Success callback (called when payment completes)
     * @param {Function} config.onError - Error callback
     * @returns {Promise<Object>} Drop-in instance
     * 
     * Note: Sessions flow - Drop-in handles payment automatically, no manual processAdyenPayment needed
     */
    )
  }, {
    key: "initializeAdyenCheckout",
    value: (function () {
      var _initializeAdyenCheckout = embedded_asyncToGenerator(/*#__PURE__*/embedded_regenerator().m(function _callee6(config) {
        var _this4 = this;
        var session, countryCode, container, onSuccess, _onError2, _session$gateway_conf2, clientKey, environment, adyenSession, sdkVersion, cdnBaseUrl, cdnJsUrl, cdnCssUrl, attempts, maxAttempts, AdyenCheckout, DropinClass, error, _error, amount, locale, checkoutConfig, checkout, Dropin, _containerElement, _error2, containerElement, dropin, _t7, _t8, _t9;
        return embedded_regenerator().w(function (_context6) {
          while (1) switch (_context6.p = _context6.n) {
            case 0:
              session = config.session, countryCode = config.countryCode, container = config.container, onSuccess = config.onSuccess, _onError2 = config.onError;
              if (!(!session || !session.gateway_config)) {
                _context6.n = 1;
                break;
              }
              throw new KoreValidationError('Invalid session: gateway_config not found');
            case 1:
              _session$gateway_conf2 = session.gateway_config, clientKey = _session$gateway_conf2.clientKey, environment = _session$gateway_conf2.environment, adyenSession = _session$gateway_conf2.session;
              if (clientKey) {
                _context6.n = 2;
                break;
              }
              throw new KoreValidationError('Adyen Drop-in requires clientKey');
            case 2:
              if (!(!adyenSession || !adyenSession.id || !adyenSession.sessionData)) {
                _context6.n = 3;
                break;
              }
              throw new KoreValidationError('Adyen session (id and sessionData) is required for Sessions flow');
            case 3:
              // Determine CDN URLs based on environment
              sdkVersion = '6.28.0';
              cdnBaseUrl = environment === 'test' ? 'https://checkoutshopper-test.adyen.com/checkoutshopper/sdk' : 'https://checkoutshopper-live.adyen.com/checkoutshopper/sdk';
              cdnJsUrl = "".concat(cdnBaseUrl, "/").concat(sdkVersion, "/adyen.js");
              cdnCssUrl = "".concat(cdnBaseUrl, "/").concat(sdkVersion, "/adyen.css"); // Load Adyen CSS stylesheet (for proper Drop-in styling)
              console.log('Loading Adyen stylesheet:', cdnCssUrl);
              _context6.p = 4;
              _context6.n = 5;
              return this.loadStylesheet(cdnCssUrl);
            case 5:
              console.log('Adyen stylesheet loaded successfully');
              _context6.n = 7;
              break;
            case 6:
              _context6.p = 6;
              _t7 = _context6.v;
              // CSS load failure is non-fatal, just log warning
              console.warn('Failed to load Adyen stylesheet, Drop-in may not display correctly:', _t7.message);
            case 7:
              _context6.p = 7;
              _context6.n = 8;
              return this.loadScript(cdnJsUrl);
            case 8:
              _context6.n = 10;
              break;
            case 9:
              _context6.p = 9;
              _t8 = _context6.v;
              if (_onError2) _onError2(_t8);
              throw _t8;
            case 10:
              // Wait for Adyen SDK to be available (race condition fix)
              // The script may load but the SDK might not be immediately available
              // Adyen Web v6 can expose itself as window.AdyenCheckout or window.AdyenWeb
              attempts = 0;
              maxAttempts = 50; // 5 seconds max wait (50 * 100ms)
            case 11:
              if (!(!window.AdyenCheckout && !window.AdyenWeb && attempts < maxAttempts)) {
                _context6.n = 13;
                break;
              }
              _context6.n = 12;
              return new Promise(function (resolve) {
                return setTimeout(resolve, 100);
              });
            case 12:
              attempts++;
              _context6.n = 11;
              break;
            case 13:
              // Get AdyenCheckout constructor - check multiple possible locations
              // Adyen Web v6 structure: window.AdyenWeb.AdyenCheckout or window.AdyenCheckout
              AdyenCheckout = null;
              if (window.AdyenCheckout) {
                AdyenCheckout = window.AdyenCheckout;
              } else if (window.AdyenWeb) {
                // AdyenWeb might be the constructor itself, or AdyenCheckout might be nested
                AdyenCheckout = window.AdyenWeb.AdyenCheckout || window.AdyenWeb;
              }

              // Also check for Dropin class availability (needed for v6)
              DropinClass = null;
              if (window.Dropin) {
                DropinClass = window.Dropin;
              } else if (window.AdyenWeb && window.AdyenWeb.Dropin) {
                DropinClass = window.AdyenWeb.Dropin;
              } else if (window.AdyenCheckout && window.AdyenCheckout.Dropin) {
                DropinClass = window.AdyenCheckout.Dropin;
              }

              // Check if SDK is available
              if (AdyenCheckout) {
                _context6.n = 14;
                break;
              }
              error = new KoreError('Adyen Drop-in SDK not loaded', 'SDK_LOAD_ERROR');
              if (_onError2) _onError2(error);
              throw error;
            case 14:
              _context6.p = 14;
              if (countryCode) {
                _context6.n = 15;
                break;
              }
              _error = new KoreValidationError('countryCode is required for Adyen Drop-in initialization');
              if (_onError2) _onError2(_error);
              throw _error;
            case 15:
              // Adyen Web v6+ approach: Create checkout instance first
              // Extract amount and currency from session (required for secured fields)
              amount = session.amount ? {
                value: session.amount,
                // Amount in minor units (e.g., cents)
                currency: session.currency || 'USD'
              } : null; // Determine locale from countryCode or use default
              // Format: language-COUNTRY (e.g., 'en-US', 'en-GB')
              locale = session.locale || (countryCode ? "en-".concat(countryCode) : 'en-US'); // Build AdyenCheckout configuration for Sessions flow
              // Reference: https://docs.adyen.com/online-payments/build-your-integration/sessions-flow
              // Sessions flow: Drop-in handles payment automatically, no manual processAdyenPayment needed
              checkoutConfig = embedded_objectSpread(embedded_objectSpread({
                clientKey: clientKey,
                environment: environment,
                countryCode: countryCode,
                // Required parameter for Adyen v6+
                locale: locale,
                // Required for proper rendering and secured fields
                // Sessions flow: pass session id and sessionData (Drop-in handles payment automatically)
                session: {
                  id: adyenSession.id,
                  sessionData: adyenSession.sessionData
                }
              }, amount && {
                amount: amount
              }), {}, {
                // onPaymentCompleted: Called when payment is completed (Sessions flow)
                // Drop-in handles the entire payment flow including 3DS automatically
                onPaymentCompleted: function () {
                  var _onPaymentCompleted2 = embedded_asyncToGenerator(/*#__PURE__*/embedded_regenerator().m(function _callee5(result, component) {
                    var sessionResult, finalStatus, _t5, _t6;
                    return embedded_regenerator().w(function (_context5) {
                      while (1) switch (_context5.p = _context5.n) {
                        case 0:
                          _context5.p = 0;
                          console.log('Adyen Drop-in onPaymentCompleted', result);
                          // Payment completed - result contains:
                          // - resultCode: Payment result (Authorised, Refused, etc.)
                          // - sessionResult: Required for backend status checks via sessions endpoint
                          // Note: pspReference might not be in the callback for Sessions flow
                          // Reference: https://docs.adyen.com/online-payments/build-your-integration/sessions-flow

                          // Extract sessionResult from result (required for backend status checks)
                          // sessionResult is the key data needed to query payment status via sessions endpoint
                          sessionResult = result.sessionResult || result.sessionData;
                          if (!sessionResult) {
                            console.warn('Adyen onPaymentCompleted: sessionResult not found in result. Status checks may not work properly.');
                          }

                          // Store sessionResult in backend for status checking
                          // pspReference might not be available in Sessions flow callback, but we can get it later via sessions endpoint
                          _context5.p = 1;
                          console.log('Updating payment gateway ID', session.session_id, result.pspReference, sessionResult);
                          _context5.n = 2;
                          return _this4.payment.updatePaymentGatewayId(session.session_id, result.pspReference || null,
                          // Optional: may not be available in Sessions flow
                          sessionResult // Required: needed for backend status checks via sessions endpoint
                          );
                        case 2:
                          _context5.n = 4;
                          break;
                        case 3:
                          _context5.p = 3;
                          _t5 = _context5.v;
                          // Log but don't fail - payment ID update is optional
                          console.warn('Failed to update payment gateway ID:', _t5.message);
                        case 4:
                          _context5.n = 5;
                          return _this4.payment.pollPaymentStatus(session.session_id, {
                            version: 'v2',
                            interval: 1000,
                            maxAttempts: 30
                          });
                        case 5:
                          finalStatus = _context5.v;
                          if (onSuccess) {
                            onSuccess(embedded_objectSpread(embedded_objectSpread({}, result), {}, {
                              session: finalStatus
                            }));
                          }
                          _context5.n = 7;
                          break;
                        case 6:
                          _context5.p = 6;
                          _t6 = _context5.v;
                          if (_onError2) _onError2(_t6);
                        case 7:
                          return _context5.a(2);
                      }
                    }, _callee5, null, [[1, 3], [0, 6]]);
                  }));
                  function onPaymentCompleted(_x7, _x8) {
                    return _onPaymentCompleted2.apply(this, arguments);
                  }
                  return onPaymentCompleted;
                }(),
                onError: function onError(error, component) {
                  if (_onError2) {
                    _onError2(error);
                  }
                }
              }); // Initialize AdyenCheckout with complete configuration
              _context6.n = 16;
              return AdyenCheckout(checkoutConfig);
            case 16:
              checkout = _context6.v;
              // Adyen Web v6+ approach: Use new Dropin() instead of checkout.create('dropin')
              // Try to get Dropin class from the locations we checked earlier
              Dropin = DropinClass; // If not found earlier, try additional locations
              if (Dropin) {
                _context6.n = 19;
                break;
              }
              if (!(checkout && checkout.Dropin)) {
                _context6.n = 17;
                break;
              }
              Dropin = checkout.Dropin;
              _context6.n = 19;
              break;
            case 17:
              if (!(checkout && typeof checkout.create === 'function')) {
                _context6.n = 19;
                break;
              }
              // Fallback to v5 approach if Dropin class not found
              _containerElement = document.querySelector(container);
              if (_containerElement) {
                _context6.n = 18;
                break;
              }
              throw new KoreValidationError("Container not found: ".concat(container));
            case 18:
              return _context6.a(2, checkout.create('dropin').mount(container));
            case 19:
              if (Dropin) {
                _context6.n = 20;
                break;
              }
              _error2 = new KoreError('Adyen Dropin class not found. Make sure you are using Adyen Web v6+ and the SDK is loaded correctly.', 'SDK_LOAD_ERROR');
              if (_onError2) _onError2(_error2);
              throw _error2;
            case 20:
              // Create and mount Drop-in using v6 approach
              // Reference: https://github.com/Adyen/adyen-web/blob/main/examples/angular/src/components/advanced-flow/advanced.component.ts
              containerElement = document.querySelector(container);
              if (containerElement) {
                _context6.n = 21;
                break;
              }
              throw new KoreValidationError("Container not found: ".concat(container));
            case 21:
              // Adyen Web v6: new Dropin(checkout, config).mount(element)
              // This is the new v6 approach as shown in Adyen's official examples
              dropin = new Dropin(checkout, {
                // Drop-in specific configuration can be added here if needed
                // paymentMethodsConfiguration: { ... } can be added here
              }).mount(containerElement);
              return _context6.a(2, dropin);
            case 22:
              _context6.p = 22;
              _t9 = _context6.v;
              if (_onError2) _onError2(_t9);
              throw _t9;
            case 23:
              return _context6.a(2);
          }
        }, _callee6, this, [[14, 22], [7, 9], [4, 6]]);
      }));
      function initializeAdyenCheckout(_x6) {
        return _initializeAdyenCheckout.apply(this, arguments);
      }
      return initializeAdyenCheckout;
    }()
    /**
     * Opens QiCard payment in iframe
     * @param {Object} config - Configuration
     * @param {Object} config.session - Session object from createEmbeddedSession
     * @param {string} config.container - CSS selector for container element
     * @param {Function} config.onSuccess - Success callback
     * @param {Function} config.onError - Error callback
     * @returns {Object} Iframe element
     */
    )
  }, {
    key: "openQiCardPayment",
    value: function openQiCardPayment(config) {
      var _this5 = this;
      var session = config.session,
        container = config.container,
        onSuccess = config.onSuccess,
        onError = config.onError;
      if (!session || !session.gateway_config) {
        throw new KoreValidationError('Invalid session: gateway_config not found');
      }
      var _session$gateway_conf3 = session.gateway_config,
        redirectUrl = _session$gateway_conf3.redirectUrl,
        embedMode = _session$gateway_conf3.embedMode;
      if (!redirectUrl) {
        throw new KoreValidationError('QiCard redirectUrl is required');
      }

      // Create iframe
      var iframe = document.createElement('iframe');
      iframe.src = redirectUrl;
      iframe.style.width = '100%';
      iframe.style.height = '600px';
      iframe.style.border = 'none';
      iframe.setAttribute('sandbox', 'allow-same-origin allow-scripts allow-forms allow-popups');
      iframe.setAttribute('title', 'QiCard Payment');

      // Append to container
      var containerElement = document.querySelector(container);
      if (!containerElement) {
        throw new KoreValidationError("Container not found: ".concat(container));
      }
      containerElement.innerHTML = ''; // Clear container
      containerElement.appendChild(iframe);

      // Start status polling
      // Note: pollPaymentStatus returns a Promise, not an interval
      // It handles its own polling internally
      this.payment.pollPaymentStatus(session.session_id, {
        version: 'v2',
        interval: 2000,
        maxAttempts: 150,
        // 5 minutes
        onStatusChange: function onStatusChange(status) {
          // Status changed, but continue polling
        }
      }).then(function (finalStatus) {
        // Polling completed
        if (finalStatus.status === 'completed') {
          if (onSuccess) {
            onSuccess(finalStatus);
          }
        } else if (finalStatus.status === 'failed' || finalStatus.status === 'canceled') {
          if (onError) {
            onError(new KoreError("Payment ".concat(finalStatus.status), 'PAYMENT_ERROR', finalStatus));
          }
        }
      })["catch"](function (error) {
        if (onError) {
          onError(error);
        }
      });

      // Listen for iframe messages (if QiCard supports it)
      var _messageHandler = function messageHandler(event) {
        // Verify origin (should match redirectUrl origin)
        try {
          var redirectOrigin = new URL(redirectUrl).origin;
          if (event.origin !== redirectOrigin) {
            return;
          }
          if (event.data && event.data.type === 'qicard-payment-complete') {
            // Poll once more to get final status
            _this5.payment.pollPaymentStatus(session.session_id, {
              version: 'v2',
              interval: 1000,
              maxAttempts: 5
            }).then(function (finalStatus) {
              if (onSuccess) {
                onSuccess(finalStatus);
              }
            })["catch"](function (error) {
              if (onError) {
                onError(error);
              }
            });

            // Remove message listener
            window.removeEventListener('message', _messageHandler);
          }
        } catch (error) {
          // Invalid URL or other error, ignore
        }
      };
      window.addEventListener('message', _messageHandler);

      // Store cleanup function on iframe
      iframe._cleanup = function () {
        window.removeEventListener('message', _messageHandler);
      };
      return iframe;
    }

    /**
     * Automatically initializes the appropriate payment form based on gateway
     * Detects gateway from session and calls the correct initialization method
     * @param {Object} config - Configuration
     * @param {Object} config.session - Session object from createEmbeddedSession
     * @param {string} config.container - CSS selector for container element
     * @param {Function} config.onSuccess - Success callback
     * @param {Function} config.onError - Error callback
     * @param {Function} config.onSuccess - Success callback (for all gateways)
     * @param {Function} config.onError - Error callback (for all gateways)
     * @returns {Promise<Object>} Payment form instance
     */
  }, {
    key: "initializePayment",
    value: (function () {
      var _initializePayment = embedded_asyncToGenerator(/*#__PURE__*/embedded_regenerator().m(function _callee7(config) {
        var _session$billing, _session$billingInfo;
        var session, container, onSuccess, onError, onSubmit, onAdditionalDetails, error, gatewayCode, countryCode, _error3, _t0, _t1, _t10;
        return embedded_regenerator().w(function (_context7) {
          while (1) switch (_context7.p = _context7.n) {
            case 0:
              session = config.session, container = config.container, onSuccess = config.onSuccess, onError = config.onError, onSubmit = config.onSubmit, onAdditionalDetails = config.onAdditionalDetails;
              if (!(!session || !session.gateway)) {
                _context7.n = 1;
                break;
              }
              error = new KoreValidationError('Invalid session: gateway information not found');
              if (onError) onError(error);
              throw error;
            case 1:
              if (!(session.gateway_config && session.gateway_config.mode === 'redirect' && session.gateway_config.redirectUrl)) {
                _context7.n = 4;
                break;
              }
              _context7.p = 2;
              this.payment.redirectToPayment(session.gateway_config.redirectUrl, {
                target: '_self'
              });
              return _context7.a(2, null);
            case 3:
              _context7.p = 3;
              _t0 = _context7.v;
              if (onError) onError(_t0);
              throw _t0;
            case 4:
              gatewayCode = session.gateway.code;
              _context7.p = 5;
              _t1 = gatewayCode;
              _context7.n = _t1 === 'checkout' ? 6 : _t1 === 'adyen' ? 8 : _t1 === 'qicard' ? 10 : 11;
              break;
            case 6:
              _context7.n = 7;
              return this.initializeCheckoutFlow({
                session: session,
                container: container,
                onSuccess: onSuccess,
                onError: onError
              });
            case 7:
              return _context7.a(2, _context7.v);
            case 8:
              // Extract countryCode from session billing info if available
              // Try multiple sources: session.billing.country, session.billingInfo.country
              countryCode = ((_session$billing = session.billing) === null || _session$billing === void 0 ? void 0 : _session$billing.country) || ((_session$billingInfo = session.billingInfo) === null || _session$billingInfo === void 0 ? void 0 : _session$billingInfo.country) || null; // Fallback to 'US' if still not available (required for Adyen v6+)
              countryCode = countryCode || 'US';

              // Sessions flow: No need to fetch payment methods - session is already created on backend
              // Just initialize Drop-in with session data
              _context7.n = 9;
              return this.initializeAdyenCheckout({
                session: session,
                countryCode: countryCode,
                container: container,
                onSuccess: onSuccess,
                onError: onError
              });
            case 9:
              return _context7.a(2, _context7.v);
            case 10:
              return _context7.a(2, this.openQiCardPayment({
                session: session,
                container: container,
                onSuccess: onSuccess,
                onError: onError
              }));
            case 11:
              _error3 = new KoreError("Unsupported gateway: ".concat(gatewayCode), 'UNSUPPORTED_GATEWAY', {
                gateway: gatewayCode
              });
              if (onError) onError(_error3);
              throw _error3;
            case 12:
              _context7.n = 14;
              break;
            case 13:
              _context7.p = 13;
              _t10 = _context7.v;
              if (onError) onError(_t10);
              throw _t10;
            case 14:
              return _context7.a(2);
          }
        }, _callee7, this, [[5, 13], [2, 3]]);
      }));
      function initializePayment(_x9) {
        return _initializePayment.apply(this, arguments);
      }
      return initializePayment;
    }())
  }]);
}();
;// ./src/utils.js
/**
 * Utility functions for the Kore SDK
 */

/**
 * Generates a UUID v4 string for use as an idempotency key
 * @returns {string} UUID v4 string
 */
function utils_generateIdempotencyKey() {
  return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
    var r = Math.random() * 16 | 0;
    var v = c === 'x' ? r : r & 0x3 | 0x8;
    return v.toString(16);
  });
}

/**
 * Formats amount in minor units to display format
 * @param {number} amount - Amount in minor units (e.g., 10000 = $100.00)
 * @param {string} currency - ISO-4217 currency code (e.g., 'USD')
 * @returns {string} Formatted amount string
 */
function utils_formatAmount(amount, currency) {
  if (typeof amount !== 'number' || amount < 0) {
    throw new Error('Amount must be a non-negative number');
  }
  if (!currency || typeof currency !== 'string') {
    throw new Error('Currency must be a valid ISO-4217 code');
  }

  // Get currency decimal places (most currencies use 2, but some use 0, 3, etc.)
  var decimalPlaces = getCurrencyDecimalPlaces(currency);
  var majorUnits = amount / Math.pow(10, decimalPlaces);

  // Format with currency symbol
  try {
    return new Intl.NumberFormat('en-US', {
      style: 'currency',
      currency: currency.toUpperCase(),
      minimumFractionDigits: decimalPlaces,
      maximumFractionDigits: decimalPlaces
    }).format(majorUnits);
  } catch (e) {
    // Fallback formatting
    return "".concat(currency.toUpperCase(), " ").concat(majorUnits.toFixed(decimalPlaces));
  }
}

/**
 * Gets decimal places for a currency
 * @private
 */
function getCurrencyDecimalPlaces(currency) {
  // Most currencies use 2 decimal places
  var zeroDecimalCurrencies = ['JPY', 'KRW', 'CLP', 'VND', 'XPF'];
  var threeDecimalCurrencies = ['BHD', 'JOD', 'KWD', 'OMR', 'TND'];
  var upperCurrency = currency.toUpperCase();
  if (zeroDecimalCurrencies.includes(upperCurrency)) {
    return 0;
  }
  if (threeDecimalCurrencies.includes(upperCurrency)) {
    return 3;
  }
  return 2;
}

/**
 * Validates ISO-4217 currency code
 * @param {string} currency - Currency code to validate
 * @returns {boolean} True if valid
 */
function utils_validateCurrency(currency) {
  if (!currency || typeof currency !== 'string') {
    return false;
  }

  // Basic validation: 3 uppercase letters
  var currencyRegex = /^[A-Z]{3}$/;
  return currencyRegex.test(currency.toUpperCase());
}

/**
 * Validates email format
 * @param {string} email - Email address to validate
 * @returns {boolean} True if valid
 */
function utils_validateEmail(email) {
  if (!email || typeof email !== 'string') {
    return false;
  }

  // RFC 5322 compliant email regex (simplified)
  var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
  return emailRegex.test(email);
}
;// ./src/index.js
function src_typeof(o) { "@babel/helpers - typeof"; return src_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, src_typeof(o); }
function src_regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return src_regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (u = i[(c = i[4]) ? 5 : (c = 3, 3)], i[4] = i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i["return"]) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (src_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, src_regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, src_regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), src_regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", src_regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), src_regeneratorDefine2(u), src_regeneratorDefine2(u, o, "Generator"), src_regeneratorDefine2(u, n, function () { return this; }), src_regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (src_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function src_regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } src_regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { function o(r, n) { src_regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); } r ? i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n : (o("next", 0), o("throw", 1), o("return", 2)); }, src_regeneratorDefine2(e, r, n, t); }
function src_asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function src_asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { src_asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { src_asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function src_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function src_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, src_toPropertyKey(o.key), o); } }
function src_createClass(e, r, t) { return r && src_defineProperties(e.prototype, r), t && src_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function src_toPropertyKey(t) { var i = src_toPrimitive(t, "string"); return "symbol" == src_typeof(i) ? i : i + ""; }
function src_toPrimitive(t, r) { if ("object" != src_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != src_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }







/**
 * Main Kore SDK class
 */
var Kore = /*#__PURE__*/function () {
  function Kore(config) {
    src_classCallCheck(this, Kore);
    if (!config || !config.apiKey) {
      throw new Error('API key is required');
    }
    this.config = {
      apiKey: config.apiKey,
      baseUrl: config.baseUrl,
      environment: config.environment || 'live',
      timeout: config.timeout || 30000,
      retryAttempts: config.retryAttempts || 3,
      retryDelay: config.retryDelay || 1000,
      onError: config.onError,
      onRequest: config.onRequest,
      onResponse: config.onResponse,
      debug: config.debug || false,
      logger: config.logger || console.log
    };

    // Initialize HTTP client
    this.client = new HttpClient(this.config);

    // Initialize payment service
    this.payment = new PaymentService(this.client);

    // Initialize embedded payment service
    this.embedded = new EmbeddedPaymentService(this.client, this.payment);
  }

  /**
   * Creates a payment session
   * @param {Object} sessionData - Payment session data
   * @param {Object} options - Additional options
   * @returns {Promise<Object>} Session response
   */
  return src_createClass(Kore, [{
    key: "createSession",
    value: (function () {
      var _createSession = src_asyncToGenerator(/*#__PURE__*/src_regenerator().m(function _callee(sessionData) {
        var options,
          _args = arguments;
        return src_regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              options = _args.length > 1 && _args[1] !== undefined ? _args[1] : {};
              return _context.a(2, this.payment.createSession(sessionData, options));
          }
        }, _callee, this);
      }));
      function createSession(_x) {
        return _createSession.apply(this, arguments);
      }
      return createSession;
    }()
    /**
     * Gets payment session status
     * @param {string} sessionId - Session ID
     * @returns {Promise<Object>} Session status
     */
    )
  }, {
    key: "getSessionStatus",
    value: (function () {
      var _getSessionStatus = src_asyncToGenerator(/*#__PURE__*/src_regenerator().m(function _callee2(sessionId) {
        return src_regenerator().w(function (_context2) {
          while (1) switch (_context2.n) {
            case 0:
              return _context2.a(2, this.payment.getSessionStatus(sessionId));
          }
        }, _callee2, this);
      }));
      function getSessionStatus(_x2) {
        return _getSessionStatus.apply(this, arguments);
      }
      return getSessionStatus;
    }()
    /**
     * Gets transaction details
     * @param {string|number} paymentId - Payment ID
     * @returns {Promise<Object>} Transaction details
     */
    )
  }, {
    key: "getTransaction",
    value: (function () {
      var _getTransaction = src_asyncToGenerator(/*#__PURE__*/src_regenerator().m(function _callee3(paymentId) {
        return src_regenerator().w(function (_context3) {
          while (1) switch (_context3.n) {
            case 0:
              return _context3.a(2, this.payment.getTransaction(paymentId));
          }
        }, _callee3, this);
      }));
      function getTransaction(_x3) {
        return _getTransaction.apply(this, arguments);
      }
      return getTransaction;
    }()
    /**
     * Redirects browser to payment gateway
     * @param {string} redirectUrl - Redirect URL from createSession
     * @param {Object} options - Redirect options
     */
    )
  }, {
    key: "redirectToPayment",
    value: function redirectToPayment(redirectUrl) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      return this.payment.redirectToPayment(redirectUrl, options);
    }

    /**
     * Polls payment status until completion or failure
     * @param {string} sessionId - Session ID
     * @param {Object} options - Polling options
     * @returns {Promise<Object>} Final session status
     */
  }, {
    key: "pollPaymentStatus",
    value: (function () {
      var _pollPaymentStatus = src_asyncToGenerator(/*#__PURE__*/src_regenerator().m(function _callee4(sessionId) {
        var options,
          _args4 = arguments;
        return src_regenerator().w(function (_context4) {
          while (1) switch (_context4.n) {
            case 0:
              options = _args4.length > 1 && _args4[1] !== undefined ? _args4[1] : {};
              return _context4.a(2, this.payment.pollPaymentStatus(sessionId, options));
          }
        }, _callee4, this);
      }));
      function pollPaymentStatus(_x4) {
        return _pollPaymentStatus.apply(this, arguments);
      }
      return pollPaymentStatus;
    }()
    /**
     * Creates an embedded payment session.
     * Gateway is selected at session creation.
     * @param {Object} sessionData - Payment session data
     * @param {Object} options - Additional options
     * @returns {Promise<Object>} Session response with gateway-specific config
     */
    )
  }, {
    key: "createEmbeddedSession",
    value: (function () {
      var _createEmbeddedSession = src_asyncToGenerator(/*#__PURE__*/src_regenerator().m(function _callee5(sessionData) {
        var options,
          _args5 = arguments;
        return src_regenerator().w(function (_context5) {
          while (1) switch (_context5.n) {
            case 0:
              options = _args5.length > 1 && _args5[1] !== undefined ? _args5[1] : {};
              return _context5.a(2, this.payment.createEmbeddedSession(sessionData, options));
          }
        }, _callee5, this);
      }));
      function createEmbeddedSession(_x5) {
        return _createEmbeddedSession.apply(this, arguments);
      }
      return createEmbeddedSession;
    }()
    /**
     * Gets Adyen payment methods for Drop-in SDK
     * @param {string} sessionId - Session ID (optional)
     * @param {Object} options - Options (countryCode, currency)
     * @returns {Promise<Object>} Payment methods response
     */
    )
  }, {
    key: "getAdyenPaymentMethods",
    value: (function () {
      var _getAdyenPaymentMethods = src_asyncToGenerator(/*#__PURE__*/src_regenerator().m(function _callee6() {
        var sessionId,
          options,
          _args6 = arguments;
        return src_regenerator().w(function (_context6) {
          while (1) switch (_context6.n) {
            case 0:
              sessionId = _args6.length > 0 && _args6[0] !== undefined ? _args6[0] : null;
              options = _args6.length > 1 && _args6[1] !== undefined ? _args6[1] : {};
              return _context6.a(2, this.payment.getAdyenPaymentMethods(sessionId, options));
          }
        }, _callee6, this);
      }));
      function getAdyenPaymentMethods() {
        return _getAdyenPaymentMethods.apply(this, arguments);
      }
      return getAdyenPaymentMethods;
    }()
    /**
     * Processes Adyen payment after user submits form
     * @param {Object} data - Payment data
     * @returns {Promise<Object>} Payment result (may contain action for 3DS)
     */
    )
  }, {
    key: "processAdyenPayment",
    value: (function () {
      var _processAdyenPayment = src_asyncToGenerator(/*#__PURE__*/src_regenerator().m(function _callee7(data) {
        return src_regenerator().w(function (_context7) {
          while (1) switch (_context7.n) {
            case 0:
              return _context7.a(2, this.payment.processAdyenPayment(data));
          }
        }, _callee7, this);
      }));
      function processAdyenPayment(_x6) {
        return _processAdyenPayment.apply(this, arguments);
      }
      return processAdyenPayment;
    }()
    /**
     * Updates payment with gateway payment ID
     * Used when Checkout.com Flow SDK completes and provides payment ID
     * @param {string} sessionId - Session ID
     * @param {string} gatewayPaymentId - Gateway payment ID
     * @returns {Promise<Object>} Updated payment
     */
    )
  }, {
    key: "updatePaymentGatewayId",
    value: (function () {
      var _updatePaymentGatewayId = src_asyncToGenerator(/*#__PURE__*/src_regenerator().m(function _callee8(sessionId) {
        var gatewayPaymentId,
          gatewaySessionResult,
          _args8 = arguments;
        return src_regenerator().w(function (_context8) {
          while (1) switch (_context8.n) {
            case 0:
              gatewayPaymentId = _args8.length > 1 && _args8[1] !== undefined ? _args8[1] : null;
              gatewaySessionResult = _args8.length > 2 && _args8[2] !== undefined ? _args8[2] : null;
              return _context8.a(2, this.payment.updatePaymentGatewayId(sessionId, gatewayPaymentId, gatewaySessionResult));
          }
        }, _callee8, this);
      }));
      function updatePaymentGatewayId(_x7) {
        return _updatePaymentGatewayId.apply(this, arguments);
      }
      return updatePaymentGatewayId;
    }()
    /**
     * Initializes Checkout.com Flow SDK
     * @param {Object} config - Configuration
     * @returns {Promise<Object>} Flow instance
     */
    )
  }, {
    key: "initializeCheckoutFlow",
    value: (function () {
      var _initializeCheckoutFlow = src_asyncToGenerator(/*#__PURE__*/src_regenerator().m(function _callee9(config) {
        return src_regenerator().w(function (_context9) {
          while (1) switch (_context9.n) {
            case 0:
              return _context9.a(2, this.embedded.initializeCheckoutFlow(config));
          }
        }, _callee9, this);
      }));
      function initializeCheckoutFlow(_x8) {
        return _initializeCheckoutFlow.apply(this, arguments);
      }
      return initializeCheckoutFlow;
    }()
    /**
     * Initializes Adyen Drop-in SDK using Sessions flow
     * @param {Object} config - Configuration
     * @param {Object} config.session - Session object with gateway_config.session (id and sessionData)
     * @param {string} config.countryCode - Country code (required for Adyen v6+)
     * @param {string} config.container - CSS selector for container element
     * @param {Function} config.onSuccess - Success callback
     * @param {Function} config.onError - Error callback
     * @returns {Promise<Object>} Drop-in instance
     */
    )
  }, {
    key: "initializeAdyenCheckout",
    value: (function () {
      var _initializeAdyenCheckout = src_asyncToGenerator(/*#__PURE__*/src_regenerator().m(function _callee0(config) {
        return src_regenerator().w(function (_context0) {
          while (1) switch (_context0.n) {
            case 0:
              return _context0.a(2, this.embedded.initializeAdyenCheckout(config));
          }
        }, _callee0, this);
      }));
      function initializeAdyenCheckout(_x9) {
        return _initializeAdyenCheckout.apply(this, arguments);
      }
      return initializeAdyenCheckout;
    }()
    /**
     * Opens QiCard payment in iframe
     * @param {Object} config - Configuration
     * @returns {Object} Iframe element
     */
    )
  }, {
    key: "openQiCardPayment",
    value: function openQiCardPayment(config) {
      return this.embedded.openQiCardPayment(config);
    }

    /**
     * Automatically initializes the appropriate payment form based on gateway
     * This is the recommended method - it detects the gateway and initializes the correct form
     * @param {Object} config - Configuration
     * @param {Object} config.session - Session object from createEmbeddedSession
     * @param {string} config.container - CSS selector for container element
     * @param {Function} config.onSuccess - Success callback
     * @param {Function} config.onError - Error callback
     * @param {Function} config.onSuccess - Success callback (for all gateways)
     * @param {Function} config.onError - Error callback (for all gateways)
     * @returns {Promise<Object>} Payment form instance
     */
  }, {
    key: "initializePayment",
    value: (function () {
      var _initializePayment = src_asyncToGenerator(/*#__PURE__*/src_regenerator().m(function _callee1(config) {
        return src_regenerator().w(function (_context1) {
          while (1) switch (_context1.n) {
            case 0:
              return _context1.a(2, this.embedded.initializePayment(config));
          }
        }, _callee1, this);
      }));
      function initializePayment(_x0) {
        return _initializePayment.apply(this, arguments);
      }
      return initializePayment;
    }()
    /**
     * Verifies redirect signature (synchronous - limited functionality)
     * Note: For full verification, use verifyRedirectSignatureAsync or verify server-side
     * @param {Object} params - Redirect parameters
     * @param {string} apiSecret - Merchant API secret
     * @returns {boolean} True if signature is valid
     */
    )
  }, {
    key: "verifyRedirectSignature",
    value: function verifyRedirectSignature(params, apiSecret) {
      return signature_verifyRedirectSignature(params, apiSecret);
    }

    /**
     * Verifies redirect signature asynchronously using Web Crypto API
     * @param {Object} params - Redirect parameters
     * @param {string} apiSecret - Merchant API secret
     * @returns {Promise<boolean>} True if signature is valid
     */
  }, {
    key: "verifyRedirectSignatureAsync",
    value: (function () {
      var _verifyRedirectSignatureAsync2 = src_asyncToGenerator(/*#__PURE__*/src_regenerator().m(function _callee10(params, apiSecret) {
        return src_regenerator().w(function (_context10) {
          while (1) switch (_context10.n) {
            case 0:
              return _context10.a(2, signature_verifyRedirectSignatureAsync(params, apiSecret));
          }
        }, _callee10);
      }));
      function verifyRedirectSignatureAsync(_x1, _x10) {
        return _verifyRedirectSignatureAsync2.apply(this, arguments);
      }
      return verifyRedirectSignatureAsync;
    }()
    /**
     * Handles redirect return from payment gateway
     * Parses URL parameters, verifies signature, and returns structured result
     * @param {URLSearchParams|Object} urlParams - URL search parameters from returnUrl
     * @param {string} apiSecret - Merchant API secret (server-side recommended)
     * @returns {Promise<Object>} Structured result with success/error data
     */
    )
  }, {
    key: "handleRedirectReturn",
    value: (function () {
      var _handleRedirectReturn = src_asyncToGenerator(/*#__PURE__*/src_regenerator().m(function _callee11(urlParams, apiSecret) {
        return src_regenerator().w(function (_context11) {
          while (1) switch (_context11.n) {
            case 0:
              return _context11.a(2, this.payment.handleRedirectReturn(urlParams, apiSecret));
          }
        }, _callee11, this);
      }));
      function handleRedirectReturn(_x11, _x12) {
        return _handleRedirectReturn.apply(this, arguments);
      }
      return handleRedirectReturn;
    }()
    /**
     * Static method: Generate idempotency key
     * @returns {string} UUID v4 string
     */
    )
  }], [{
    key: "generateIdempotencyKey",
    value: function generateIdempotencyKey() {
      return utils_generateIdempotencyKey();
    }

    /**
     * Static method: Format amount
     * @param {number} amount - Amount in minor units
     * @param {string} currency - ISO-4217 currency code
     * @returns {string} Formatted amount string
     */
  }, {
    key: "formatAmount",
    value: function formatAmount(amount, currency) {
      return utils_formatAmount(amount, currency);
    }

    /**
     * Static method: Validate currency
     * @param {string} currency - Currency code to validate
     * @returns {boolean} True if valid
     */
  }, {
    key: "validateCurrency",
    value: function validateCurrency(currency) {
      return utils_validateCurrency(currency);
    }

    /**
     * Static method: Validate email
     * @param {string} email - Email address to validate
     * @returns {boolean} True if valid
     */
  }, {
    key: "validateEmail",
    value: function validateEmail(email) {
      return utils_validateEmail(email);
    }
  }]);
}();

// Add ErrorCodes as static property
Kore.ErrorCodes = ErrorCodes;

// Export default
/* harmony default export */ const src = (Kore);

// Export all error classes


// Export utility functions

/******/ 	return __webpack_exports__;
/******/ })()
;
});